% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_check.R
\name{check_class_and_type}
\alias{check_class_and_type}
\title{Check class and type}
\usage{
check_class_and_type(
  object,
  object_name = NULL,
  type_classes = "bool",
  allow_NULL = FALSE,
  min = NULL,
  max = NULL,
  allowed_values = NULL
)
}
\arguments{
\item{object}{Any R object.}

\item{object_name}{\code{string} Name of the object. This is helpful for debugging.}

\item{type_classes}{\code{vector} of \code{string}s containing the type or classes which the object should belong to.}

\item{allow_NULL}{\code{bool} If \code{TRUE} allow the object to be \code{NULL}.}

\item{min}{\code{double} or \code{int} Minimal value for the object.}

\item{max}{\code{double} or \code{int} Maximal value for the object.}

\item{allowed_values}{\code{vector} of \code{string}s determining the allowed values. If all strings are allowed
set this argument to \code{NULL}.}
}
\value{
Function does nothing return. It raises an error if the object is not of the specified type.
}
\description{
Function for checking if an object is of a specific type or class.
}
\note{
parameter \code{min}, \code{max}, and \code{allowed_values} do not apply if \code{type_classes} is a class.

allowed_values does only apply if \code{type_classes} is \code{string}.
}
\seealso{
Other Utils Checks Developers: 
\code{\link{check_all_args}()}
}
\concept{Utils Checks Developers}
