\name{index_lp}
\alias{index_lp}
\alias{index.lp}
\title{The l_p-index}
\usage{
  index_lp(x, p = Inf, projection = prod)

  index.lp(x, p = Inf, projection = prod) # deprecated
    alias
}
\arguments{
  \item{x}{a non-negative numeric vector}

  \item{p}{index order, \eqn{p \in [1,\infty]}{p in
  [1,\infty]}; defaults \eqn{\infty} (\code{Inf}).}

  \item{projection}{function}
}
\value{
  result of \code{projection}(\code{c}(\eqn{i, x_i}))
}
\description{
  Given a sequence of \eqn{n} non-negative numbers
  \eqn{x=(x_1,\dots,x_n)}, where \eqn{x_i \ge x_j} for
  \eqn{i \le j}, the \dfn{\eqn{l_p}-index} for
  \eqn{p=\infty} equals to \deqn{l_p(x)=\arg\max_{(i,x_i),
  i=1,\dots,n} \{ i x_i \}}{ l_p(x) = arg max_(i,x_i) {
  i*x_i } for i=1,\dots,n} if \eqn{n \ge 1}, or
  \eqn{l_\infty(x)=0} otherwise. Note that if
  \eqn{(i,x_i)=l_\infty(x)}, then \deqn{MAXPROD(x) =
  \mathtt{prod}(l_\infty(x)) = i x_i,}{ MAXPROD(x) =
  prod(l_\infty(x)) = i*x_i,} where \eqn{MAXPROD} is the
  index proposed in (Kosmulski, 2007), see
  \code{\link{index_maxprod}}.

  For the definition of the \eqn{l_p}-index for \eqn{p <
  \infty} we refer to (Gagolewski, Grzegorzewski, 2009a).
}
\details{
  The \eqn{l_p}-index, by definition, is not an impact
  function, as it produces 2 numeric values. Thus, it
  should be projected to one dimension. However, you may
  set \code{projection} to \code{\link{identity}} to obtain
  the 2-dimensional index

  If non-increasingly sorted vector is given, the function
  is O(n).

  For historical reasons, this function is also available
  via its alias, \code{index.lp} [but its usage is
  deprecated].
}
\examples{
x <- runif(100, 0, 100)
index.lp(x, Inf, identity)  # two-dimensional value, can not be used
                            # directly in the analysis
index.lp(x, Inf, prod)      # the MAXPROD-index (one-dimensional) [default]
}
\references{
  Gagolewski M., Grzegorzewski P., A geometric approach to
  the construction of scientific impact indices,
  Scientometrics, 81(3), 2009a, pp. 617-634.\cr Gagolewski
  M., Debski M., Nowakiewicz M., Efficient algorithms for
  computing ''geometric'' scientific impact indices,
  Research Report of Systems Research Institute, Polish
  Academy of Sciences RB/1/2009, 2009b.\cr Kosmulski M.,
  MAXPROD - A new index for assessment of the scientific
  output of an individual, and a comparison with the
  h-index, Cybermetrics, 11(1), 2007.\cr
}
\seealso{
  Other impact_functions: \code{\link{index_g}},
  \code{\link{index_g_zi}}, \code{\link{index_h}},
  \code{\link{index_maxprod}}, \code{\link{index_rp}},
  \code{\link{index_w}}, \code{\link{index.g}},
  \code{\link{index.h}}, \code{\link{index.rp}}
}

