% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breaks_to_interval.R
\name{breaks_to_interval}
\alias{breaks_to_interval}
\title{Convert breaks to an interval}
\usage{
breaks_to_interval(breaks, max_upper = Inf)
}
\arguments{
\item{breaks}{\verb{[integerish]}.

1 or more non-negative cut points in increasing (strictly) order.

These correspond to the left hand side of the desired intervals (e.g. the
closed side of [x, y).

Double values are coerced to integer prior to categorisation.}

\item{max_upper}{\verb{[numeric]}

Represents the maximum upper bound splitting the data.

Defaults to \code{Inf}.}
}
\value{
A \link[tibble:tbl_df-class]{tibble} with an ordered factor column (\code{interval}),
as well as columns corresponding to the explicit bounds (\code{lower_bound} and
\code{upper_bound}). Note that even those these bounds are whole numbers they are
returned as \code{numeric} to allow the maximum upper bound to be given as \code{Inf}.
}
\description{
\code{breaks_to_interval()} takes a specified set of breaks representing the left
hand limits of a closed open interval, i.e [x, y), and returns the
corresponding interval and upper bounds. The resulting intervals span from
the minimum break through to a specified \code{max_upper}.
}
\examples{

breaks_to_interval(breaks = c(0L, 1L, 5L, 15L, 25L, 45L, 65L))
breaks_to_interval(
    breaks = c(0L, 1L, 5L, 15L, 25L, 45L, 65L),
    max_upper = 100L
)

}
