% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoStageDesign.R, R/OneStageDesign.R,
%   R/GroupSequentialDesign.R
\name{n1}
\alias{n1}
\alias{n1,TwoStageDesign-method}
\alias{n2}
\alias{n2,TwoStageDesign,numeric-method}
\alias{n}
\alias{n,TwoStageDesign,numeric-method}
\alias{n2,OneStageDesign,numeric-method}
\alias{n2,GroupSequentialDesign,numeric-method}
\title{Query sample size of a design}
\usage{
n1(d, ...)

\S4method{n1}{TwoStageDesign}(d, round = TRUE, ...)

n2(d, x1, ...)

\S4method{n2}{TwoStageDesign,numeric}(d, x1, round = TRUE, ...)

n(d, x1, ...)

\S4method{n}{TwoStageDesign,numeric}(d, x1, round = TRUE, ...)

\S4method{n2}{OneStageDesign,numeric}(d, x1, ...)

\S4method{n2}{GroupSequentialDesign,numeric}(d, x1, round = TRUE, ...)
}
\arguments{
\item{d}{design}

\item{...}{further optional arguments}

\item{round}{\code{logical} should sample sizes be rounded to next integer?}

\item{x1}{stage-one test statistic}
}
\value{
sample size value of design \code{d} at point \code{x1}
}
\description{
Methods to access the stage-one, stage-two, or overall sample size of a
\code{\link{TwoStageDesign}}.
\code{n1} returns the first-stage sample size of a design,
\code{n2} the stage-two sample size conditional on the stage-one test
statistic and \code{n} the overall sample size \code{n1 + n2}.
Internally, objects of the class \code{TwoStageDesign} allow non-natural,
real sample sizes to allow smooth optimization (cf. \code{\link{minimize}} for
details).
The optional argument \code{round} allows to switch between the internal
real representation and a rounded version (rounding to the next positive
integer).
}
\examples{
design <- TwoStageDesign(
   n1    = 25,
   c1f   = 0,
   c1e   = 2.5,
   n2    = 50,
   c2    = 1.96,
   order = 7L
)

n1(design) # 25
design@n1 # 25

n(design, x1 = 2.2) # 75


}
\seealso{
\code{\link{TwoStageDesign}}, see \code{\link{c2}} for accessing
the critical values
}
