% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoStageDesign.R
\name{make_tunable}
\alias{make_tunable}
\alias{make_tunable,TwoStageDesign-method}
\alias{make_fixed}
\alias{make_fixed,TwoStageDesign-method}
\title{Fix parameters during optimization}
\usage{
make_tunable(x, ...)

\S4method{make_tunable}{TwoStageDesign}(x, ...)

make_fixed(x, ...)

\S4method{make_fixed}{TwoStageDesign}(x, ...)
}
\arguments{
\item{x}{\code{TwoStageDesign} object}

\item{...}{unquoted names of slots for which the tunability status should be
changed.}
}
\description{
The methods \code{make_fixed} and \code{make_tunable} can be used to modify
the 'tunability' status of parameters in a \code{\link{TwoStageDesign}}
object.
Tunable parameters are optimized over, non-tunable ('fixed') parameters are
considered given and not altered during optimization.
}
\examples{
design <- TwoStageDesign(25, 0, 2, 25, 2, order = 5)
# default: all parameters are tunable (except integration pivots,
# weights and tunability status itself)
design@tunable

# make n1 and the pivots of n2 fixed (not changed during optimization)
design <- make_fixed(design, n1, n2_pivots)
design@tunable

# make them tunable again
design <- make_tunable(design, n1, n2_pivots)
design@tunable

}
\seealso{
\code{\link{TwoStageDesign}}, \code{\link{tunable_parameters}} for
converting tunable parameters of a design object to a numeric vector (and back),
and \code{\link{minimize}} for the actual minimzation procedure
}
