% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admix_cluster.R
\name{admix_cluster}
\alias{admix_cluster}
\title{Clustering of K populations following admixture models}
\usage{
admix_cluster(
  samples,
  admixMod,
  conf_level = 0.95,
  n_sim_tab = 100,
  tune_penalty = FALSE,
  tabul_dist = NULL,
  echo = TRUE,
  parallel = FALSE,
  n_cpu = 2
)
}
\arguments{
\item{samples}{(list) A list of the K (K>0) samples to be studied, all following admixture distributions.}

\item{admixMod}{(list) A list of objects of class 'admix_model', containing useful information about distributions and parameters.}

\item{conf_level}{The confidence level of the K-sample test used in the clustering procedure.}

\item{n_sim_tab}{Number of simulated gaussian processes used in the tabulation of the inner convergence distribution in the IBM approach.}

\item{tune_penalty}{A boolean that allows to choose between a classical penalty term or an optimized penalty embedding some tuning parameters
(automatically optimized) for k-sample tests used within the clustering procedure.
Optimized penalty is particularly useful for low sample size.}

\item{tabul_dist}{(Only useful for comparisons of detected clusters at different confidence levels) A list of the tabulated distributions
of the stochastic integral for each cluster previously detected.}

\item{echo}{(default to TRUE) Display the remaining computation time.}

\item{parallel}{(default to FALSE) Boolean to indicate whether parallel computations are performed (speed-up the tabulation).}

\item{n_cpu}{(default to 2) Number of cores used when parallelizing.}
}
\value{
An object of class 'admix_cluster', containing 12 attributes: 1) the number of samples under study; 2) the sizes of samples;
3) the information about mixture components in each sample (distributions and parameters); 4) the number of detected clusters;
5) the list of p-values for each k-sample test at the origin of detected clusters; 6) the cluster affiliation for each sample;
7) the confidence level of statistical tests; 8) which samples in which cluster; 9) the size of clusters; 10) the estimated
weights of the unknown component distributions inside each cluster (remind that estimated weights are consistent only if
unknown components are tested to be identical, which is the case inside clusters); 11) the matrix of pairwise discrepancies
across all samples; 12) the list of tabulated distributions used for statistical tests involved in building the clusters.
}
\description{
Create clusters on the unknown components related to the K populations following admixture models. Based on the K-sample test
using Inversion - Best Matching (IBM) approach, see 'Details' below for further information.
}
\examples{
\donttest{
## Simulate mixture data:
mixt1 <- twoComp_mixt(n = 2600, weight = 0.8,
                      comp.dist = list("gamma", "exp"),
                      comp.param = list(list("shape" = 16, "scale" = 1/4),
                                        list("rate" = 1/3.5)))
mixt2 <- twoComp_mixt(n = 3000, weight = 0.7,
                      comp.dist = list("gamma", "exp"),
                      comp.param = list(list("shape" = 14, "scale" = 1/2),
                                        list("rate" = 1/5)))
mixt3 <- twoComp_mixt(n = 3500, weight = 0.6,
                      comp.dist = list("gamma", "gamma"),
                      comp.param = list(list("shape" = 16, "scale" = 1/4),
                                        list("shape" = 12, "scale" = 1/2)))
mixt4 <- twoComp_mixt(n = 4800, weight = 0.5,
                      comp.dist = list("gamma", "exp"),
                      comp.param = list(list("shape" = 14, "scale" = 1/2),
                                        list("rate" = 1/7)))
data1 <- getmixtData(mixt1)
data2 <- getmixtData(mixt2)
data3 <- getmixtData(mixt3)
data4 <- getmixtData(mixt4)

## Define the admixture models:
admixMod1 <- admix_model(knownComp_dist = mixt1$comp.dist[[2]],
                         knownComp_param = mixt1$comp.param[[2]])
admixMod2 <- admix_model(knownComp_dist = mixt2$comp.dist[[2]],
                         knownComp_param = mixt2$comp.param[[2]])
admixMod3 <- admix_model(knownComp_dist = mixt3$comp.dist[[2]],
                         knownComp_param = mixt3$comp.param[[2]])
admixMod4 <- admix_model(knownComp_dist = mixt4$comp.dist[[2]],
                         knownComp_param = mixt4$comp.param[[2]])

admix_cluster(samples = list(data1, data2, data3, data4),
              admixMod = list(admixMod1, admixMod2, admixMod3, admixMod4),
              conf_level = 0.95, n_sim_tab = 30, tune_penalty = TRUE,
              tabul_dist = NULL, echo = FALSE, parallel = FALSE, n_cpu = 2)
}

}
\references{
\insertRef{MilhaudPommeretSalhiVandekerkhove2024b}{admix}
}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
