% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_country_codes.R
\docType{data}
\name{country_code_lookup}
\alias{country_code_lookup}
\title{Country Code Lookup}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 249 rows and 3 columns.
}
\usage{
country_code_lookup
}
\description{
These pre-defined country codes are sourced from
\href{https://www.iso.org/iso-3166-country-codes.html}{ISO 3166 Standards}.
See also \href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3}{Wikipedia}.
}
\details{
\code{country_code} is the 3-letter ISO 3166-1 county code commonly found in the
ADSL \code{COUNTRY} variable.
\code{country_name} is the country long name corresponding to to the 3-letter code.
\code{country_number} is the numeric code corresponding to an alphabetic sorting of
the 3-letter codes.

To see the entire table in the console, run \code{print(country_code_lookup)}.
}
\examples{
library(tibble)
library(dplyr, warn.conflicts = FALSE)
library(lubridate)

# Create reference dataset for periods
adsl <- tribble(
  ~USUBJID, ~SEX, ~COUNTRY,
  "ST01-01", "F", "AUT",
  "ST01-02", "M", "MWI",
  "ST01-03", "F", "GBR",
  "ST01-04", "M", "CHE",
  "ST01-05", "M", "NOR",
  "ST01-06", "F", "JPN",
  "ST01-07", "F", "USA"
)

covar <- adsl \%>\%
  derive_vars_merged(
    dataset_add = country_code_lookup,
    new_vars = exprs(COUNTRYN = country_number, COUNTRYL = country_name),
    by_vars = exprs(COUNTRY = country_code)
  )
covar

}
\seealso{
\link{dose_freq_lookup}

Other metadata: 
\code{\link{atoxgr_criteria_ctcv4}},
\code{\link{atoxgr_criteria_ctcv5}},
\code{\link{atoxgr_criteria_daids}},
\code{\link{dose_freq_lookup}}
}
\concept{metadata}
\keyword{metadata}
