% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_extreme_flag.R
\name{derive_extreme_flag}
\alias{derive_extreme_flag}
\title{Add a Variable Flagging the First or Last Observation Within Each By Group}
\usage{
derive_extreme_flag(
  dataset,
  by_vars,
  order,
  new_var,
  mode,
  filter = NULL,
  check_type = "warning"
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} parameter are expected.}

\item{by_vars}{Grouping variables

Permitted Values: list of variables}

\item{order}{Sort order

The first or last observation is determined with respect to the specified
order.

Permitted Values: list of variables or functions of variables}

\item{new_var}{Variable to add

The specified variable is added to the output dataset. It is set to \code{"Y"}
for the first or last observation (depending on the mode) of each by group.

Permitted Values: list of name-value pairs}

\item{mode}{Flag mode

Determines of the first or last observation is flagged.

Permitted Values: \code{"first"}, \code{"last"}}

\item{filter}{Filter for flag data

Only observations fulfilling the specified condition are taken into account
for flagging. If the parameter is not specified, all observations are
considered.

Permitted Values: a condition}

\item{check_type}{Check uniqueness?

If \code{"warning"} or \code{"error"} is specified, the specified message is issued
if the observations of the input dataset are not unique with respect to the
by variables and the order.

Default: \code{"warning"}

Permitted Values: \code{"none"}, \code{"warning"}, \code{"error"}}
}
\value{
The input dataset with the new flag variable added
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\emph{Deprecated}, please use \code{derive_var_extreme_flag()} instead.

Add a variable flagging the first or last observation within each by group
}
\details{
For each group (with respect to the variables specified for the
\code{by_vars} parameter), \code{new_var} is set to "Y" for the first or last observation
(with respect to the order specified for the \code{order} parameter and the flag mode
specified for the \code{mode} parameter). Only observations included by the \code{filter} parameter
are considered for flagging.
Otherwise, \code{new_var} is set to \code{NA}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(admiral.test)
data("vs")

# Flag last value for each patient, test, and visit, baseline observations are ignored
vs \%>\%
  derive_extreme_flag(
    by_vars = vars(USUBJID, VSTESTCD, VISIT),
    order = vars(VSTPTNUM),
    new_var = LASTFL,
    mode = "last",
    filter = VISIT != "BASELINE"
  ) \%>\%
  arrange(USUBJID, VSTESTCD, VISITNUM, VSTPTNUM) \%>\%
  select(USUBJID, VSTESTCD, VISIT, VSTPTNUM, VSSTRESN, LASTFL)

# Baseline (ABLFL) examples:

input <- tibble::tribble(
  ~STUDYID, ~USUBJID, ~PARAMCD,  ~AVISIT,    ~ADT,                 ~AVAL, ~DTYPE,
  "TEST01", "PAT01",  "PARAM01", "BASELINE", as.Date("2021-04-27"), 15.0, NA,
  "TEST01", "PAT01",  "PARAM01", "BASELINE", as.Date("2021-04-25"), 14.0, NA,
  "TEST01", "PAT01",  "PARAM01", "BASELINE", as.Date("2021-04-23"), 15.0, "AVERAGE",
  "TEST01", "PAT01",  "PARAM01", "WEEK 1",   as.Date("2021-04-27"), 10.0, "AVERAGE",
  "TEST01", "PAT01",  "PARAM01", "WEEK 2",   as.Date("2021-04-30"), 12.0, NA,

  "TEST01", "PAT02",  "PARAM01", "SCREENING",as.Date("2021-04-27"), 15.0, "AVERAGE",
  "TEST01", "PAT02",  "PARAM01", "BASELINE", as.Date("2021-04-25"), 14.0, "AVERAGE",
  "TEST01", "PAT02",  "PARAM01", "BASELINE", as.Date("2021-04-23"), 15.0, "AVERAGE",
  "TEST01", "PAT02",  "PARAM01", "WEEK 1",   as.Date("2021-04-27"), 10.0, "AVERAGE",
  "TEST01", "PAT02",  "PARAM01", "WEEK 2",   as.Date("2021-04-30"), 12.0, "AVERAGE",

  "TEST01", "PAT01",  "PARAM02", "SCREENING",as.Date("2021-04-27"), 15.0, "AVERAGE",
  "TEST01", "PAT01",  "PARAM02", "SCREENING",as.Date("2021-04-25"), 14.0, "AVERAGE",
  "TEST01", "PAT01",  "PARAM02", "SCREENING",as.Date("2021-04-23"), 15.0, NA,
  "TEST01", "PAT01",  "PARAM02", "BASELINE", as.Date("2021-04-27"), 10.0, "AVERAGE",
  "TEST01", "PAT01",  "PARAM02", "WEEK 2",   as.Date("2021-04-30"), 12.0, NA,

  "TEST01", "PAT02",  "PARAM02", "SCREENING",as.Date("2021-04-27"), 15.0, NA,
  "TEST01", "PAT02",  "PARAM02", "BASELINE", as.Date("2021-04-25"), 14.0, NA,
  "TEST01", "PAT02",  "PARAM02", "WEEK 1",   as.Date("2021-04-23"), 15.0, NA,
  "TEST01", "PAT02",  "PARAM02", "WEEK 1",   as.Date("2021-04-27"), 10.0, NA,
  "TEST01", "PAT02",  "PARAM02", "BASELINE", as.Date("2021-04-30"), 12.0, NA
)

# Last observation
derive_extreme_flag(
  input,
  by_vars = vars(USUBJID, PARAMCD),
  order = vars(ADT),
  new_var = ABLFL,
  mode = "last",
  filter = AVISIT == "BASELINE"
)

# Worst observation - Direction = High
derive_extreme_flag(
  input,
  by_vars = vars(USUBJID, PARAMCD),
  order = vars(AVAL, ADT),
  new_var = ABLFL,
  mode = "last",
  filter = AVISIT == "BASELINE"
)

# Worst observation - Direction = Lo
derive_extreme_flag(
  input,
  by_vars = vars(USUBJID, PARAMCD),
  order = vars(desc(AVAL), ADT),
  new_var = ABLFL,
  mode = "last",
  filter = AVISIT == "BASELINE"
)

# Average observation
derive_extreme_flag(
  input,
  by_vars = vars(USUBJID, PARAMCD),
  order = vars(ADT, desc(AVAL)),
  new_var = ABLFL,
  mode = "last",
  filter = AVISIT == "BASELINE" & DTYPE == "AVERAGE"
)
}
\author{
Stefan Bundfuss
}
\keyword{adam}
\keyword{derivation}
