% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03amigaBlockBasics.r
\docType{class}
\name{amigaBlock-class}
\alias{amigaBlock-class}
\alias{amigaBlock}
\title{The amigaBlock class}
\description{
The Commodore Amiga stores data on floppy disks as 512 byte blocks.
This class reflects such a block.
}
\details{
There are several types of blocks. Most important are the boot block
(used for booting the Amiga system), the root block (containing information
on the disk and the root directory), header blocks (indicating where to
find file data) and data blocks (containing the actual file data). See
this package's \href{../doc/amigaDiskFiles.html}{vignette} for more
details. use the \code{\link{amigaBlock-method}} to extract a specific
block from an \code{\link{amigaDisk}} object.
}
\section{Slots}{

\describe{
\item{\code{data}}{The \code{raw} data of a 'block' of data on
an Amiga disk file. Each block holds 512 bytes of information.
This slot is therefore a \code{vector} of the same length.}
}}

\examples{
## create a block with no data:
new("amigaBlock")
}
\author{
Pepijn de Vries
}
\concept{blocks}
