% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adbc.R
\name{adbc_statement_set_sql_query}
\alias{adbc_statement_set_sql_query}
\alias{adbc_statement_set_substrait_plan}
\alias{adbc_statement_prepare}
\alias{adbc_statement_get_parameter_schema}
\alias{adbc_statement_bind}
\alias{adbc_statement_bind_stream}
\alias{adbc_statement_execute_query}
\title{Statement methods}
\usage{
adbc_statement_set_sql_query(statement, query)

adbc_statement_set_substrait_plan(statement, plan)

adbc_statement_prepare(statement)

adbc_statement_get_parameter_schema(statement)

adbc_statement_bind(statement, values, schema = NULL)

adbc_statement_bind_stream(statement, stream, schema = NULL)

adbc_statement_execute_query(statement, stream = NULL)
}
\arguments{
\item{statement}{An \link[=adbc_statement_init]{adbc_statement}}

\item{query}{An SQL query as a string}

\item{plan}{A raw vector representation of a serialized Substrait plan.}

\item{values}{A \link[nanoarrow:as_nanoarrow_array]{nanoarrow_array} or object
that can be coerced to one.}

\item{schema}{A \link[nanoarrow:as_nanoarrow_schema]{nanoarrow_schema} or object
that can be coerced to one.}

\item{stream}{A \link[nanoarrow:as_nanoarrow_array_stream]{nanoarrow_array_stream}
or object that can be coerced to one.}
}
\value{
\itemize{
\item \code{adbc_statement_set_sql_query()}, \code{adbc_statement_set_substrait_plan()},
\code{adbc_statement_prepare()}, \code{adbc_statement_bind()},
\code{adbc_statement_bind_stream()}, and \code{adbc_statement_execute_query()}
return \code{statement}, invisibly.
\item \code{adbc_statement_get_parameter_schema()} returns a
\link[nanoarrow:as_nanoarrow_schema]{nanoarrow_schema}.
}
}
\description{
Statement methods
}
\examples{
db <- adbc_database_init(adbc_driver_void())
con <- adbc_connection_init(db)
stmt <- adbc_statement_init(con)
# (not implemented by the void driver)
try(adbc_statement_set_sql_query(stmt, "some query"))

}
