% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCMMplots.R
\name{multiplot}
\alias{multiplot}
\title{Plot multiple GCMM activity curves}
\usage{
multiplot(
  models,
  ymax = "NULL",
  scale = "2pi",
  lwd = 3,
  type = c("mixture", "components"),
  lty = c(1, 2, 3, 4, 5),
  col = c("grey15", "grey40", "grey55", "grey70"),
  axisunits = c("radians", "sun", "solar", "time", "none"),
  xlines = TRUE
)
}
\arguments{
\item{models}{List of one or more objects of class \code{GCMM} containing output from the \code{\link{GCMM}} function}

\item{ymax}{Value for upper limit of y-axis}

\item{scale}{Scale for the plot, either "pi" (-pi, pi) or "2pi" (0, 2pi); default is that recommended by the GCMM function}

\item{lwd}{Value for the width of the lines for the activity curves}

\item{type}{Type of activity plots, either "mixture" for mixture plots (default) or "components" for components plots}

\item{lty}{Vector of line types to use for the activity curves}

\item{col}{Vector of colours to use for the activity curve lines in the plot}

\item{axisunits}{Scale to use for the xaxis, either "radians", "time", "solar", "sun", or "none"; default="radians"}

\item{xlines}{Whether to include lines on the graph for the x axis labels; default=TRUE}
}
\value{
Prints plot
}
\description{
Plot of multiple GCMM activity curves
}
\examples{
\donttest{ FoxActivityGCMM<-GCMM(data=redfoxsample$Radians, 
              RE1=redfoxsample$SamplingPeriod, family="vonmises", autorun=FALSE,
              adapt=0, sample=300, burnin=300, thin=1, n.chains=2)
           HumanActivityGCMM<-GCMM(data=humanssample$Radians, RE1=humanssample$SamplingPeriod, 
             family="vonmises", autorun=FALSE, adapt=0, sample=300, burnin=300, thin=1, n.chains=2)
           multiplot(models=list(FoxActivityGCMM,HumanActivityGCMM)) }

}
