% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ActivityProbabilityFunctions.R
\name{circplotHPD}
\alias{circplotHPD}
\title{Circular plot of activity HPD intervals}
\usage{
circplotHPD(
  models,
  prob = 0.5,
  col = c("cyan3", "orchid", "deeppink", "dodgerblue"),
  axisunits = c("radians", "sun", "time")
)
}
\arguments{
\item{models}{List of one or more objects of class \code{GCMM} containing output from the \code{\link{GCMM}} function}

\item{prob}{Value for activityHPD probability density mass; default=0.5 (i.e. 50\% HPD)}

\item{col}{Vector of colours to use in the plot}

\item{axisunits}{Units to be used for the axis, either "radians", "sun", "time", or "none"}
}
\value{
No return value; prints plot
}
\description{
Circular plot of activity HPD intervals from GCMM activity curves
}
\examples{
\donttest{ FoxActivityGCMM<-GCMM(data=redfoxsample$Radians, 
        RE1=redfoxsample$SamplingPeriod, family="vonmises", autorun=FALSE)
     HumanActivityGCMM<-GCMM(data=humanssample$Radians, RE1=humanssample$SamplingPeriod, 
        family="vonmises", autorun=FALSE)
    circplotHPD(models=list(FoxActivityGCMM,HumanActivityGCMM)) }
}
