% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity.overlay.chart.R
\name{activity.with.overlay.chart}
\alias{activity.with.overlay.chart}
\title{Combines events file data with observational data for a single events file}
\usage{
activity.with.overlay.chart(events_file, overlay_file, output_folder)
}
\arguments{
\item{events_file}{The filepath of the events file. Must be a valid activPAL events csv file}

\item{overlay_file}{The filepath of the csv file containing the overlay data csv file}

\item{output_folder}{The filepath of the folder where the generated chart are to be saved to}
}
\description{
Reads in an events file and overlay file, generating spiral and linear
    charts aligning the events file data with the corresponding overlay data.
    Where the overlay data is non-continuous data (such as sleeps diaries) the csv
    file should have the columns start_time (dd-mm-YYYY HH:MM),
    end_time (dd-mm-YYYY HH:MM) and category (text).
    Where the overlay data is continuous data (such as continuous glucose monitoring)
    the csv file should have the columns start_time(dd-mm-YYYY HH:MM) and category (text).
    In this case the end time coincides with the start time of the subsequent observation.
    The charts are saved as png images with two images generated
    (one spiral chart and one linear chart). \cr
    \strong{Note}: Spiral plots are generated using ggplot2 and coord_polar() and can take
    45 - 60 seconds to generate each spiral plot.
}
\examples{
events_file <- system.file("extdata", "Test_Events.csv", package = "activPAL")
sleep_file <- system.file("extdata", "Sleep.csv", package = "activPAL")
output_folder <- paste(tempdir(),"/",sep="")

\donttest{activPAL::activity.with.overlay.chart(events_file,sleep_file,output_folder)}
}
