% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_results.R
\name{average_results}
\alias{average_results}
\title{Average results over valid days}
\usage{
average_results(data, minimum_wear_time = 10, fun = c("mean", "median"))
}
\arguments{
\item{data}{A dataframe obtained using the \code{\link{prepare_dataset}},  \code{\link{mark_wear_time}}, \code{\link{mark_intensity}}, and then the \code{\link{recap_by_day}} functions.}

\item{minimum_wear_time}{A numeric value (in hours) to set the minimum wear time duration for validating a day.}

\item{fun}{A character value indicating whether means or medians should be computed.}
}
\value{
A dataframe.
}
\description{
This function computes, using valid days only, the mean of each of the metrics
obtained using the \code{\link{recap_by_day}} function. The median can also
be obtained with an appropriate configuration of the function.
}
\examples{
file <- system.file("extdata", "acc.agd", package = "activAnalyzer")
mydata <- prepare_dataset(data = file)
mydata_with_wear_marks <- mark_wear_time(
    dataset = mydata, 
    TS = "TimeStamp", 
    to_epoch = 60,
    cts  = "vm",
    frame = 90, 
    allowanceFrame = 2, 
    streamFrame = 30
    )
mydata_with_intensity_marks <- mark_intensity(
    data = mydata_with_wear_marks, 
    col_axis = "vm", 
    equation = "Sasaki et al. (2011) [Adults]",
    sed_cutpoint = 200, 
    mpa_cutpoint = 2690, 
    vpa_cutpoint = 6167, 
    age = 32,
    weight = 67,
    sex = "male",
    )
summary_by_day <- recap_by_day(
    data = mydata_with_intensity_marks, 
    age = 32, 
    weight = 67, 
    sex = "male",
    valid_wear_time_start = "07:00:00",
    valid_wear_time_end = "22:00:00"
    )
average_results(data = summary_by_day, minimum_wear_time = 10)

}
