% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_data_delete.R
\name{modify_data_delete}
\alias{modify_data_delete}
\title{Delete annotations}
\usage{
modify_data_delete(
  x,
  filterContent = "",
  filterTiersInclude = "",
  filterTranscriptsInclude = ""
)
}
\arguments{
\item{x}{Corpus object.}

\item{filterContent}{Character string; all annotations will be deleted that match this regular expression.}

\item{filterTiersInclude}{Character string; filter as a regular expression, which tiers will be affected.}

\item{filterTranscriptsInclude}{Character string; filter as a regular expression, which transcripts will be affected.}
}
\value{
Corpus object.
}
\description{
Delete annotations
}
\examples{
library(act)

# Set the regular expression which annotations should be deleted.
# In this case: all annotations that contain the letter "a"
myRegEx <- "a"
# Have a look at all annotations in the first transcript
examplecorpus@transcripts[[1]]@data$content

# Some of them match to the regular expression
hits <- grep(pattern=myRegEx, x=examplecorpus@transcripts[[1]]@data$content)
examplecorpus@transcripts[[1]]@data$content[hits]
# Others don't match the regular expression
examplecorpus@transcripts[[1]]@data$content[-hits]

# Run the function and delete the annotations that match the regular expression
test <- act::modify_data_delete (x=examplecorpus, filterContent=myRegEx)

# Compare how many data rows are in the first transcript in 
# the example corpus and in the newly created test corpus:
nrow(examplecorpus@transcripts[[1]]@data)
nrow(test@transcripts[[1]]@data)

# Only the annotations are left, that did not match the regular expression:
test@transcripts[[1]]@data$content

}
