# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

accel.artifacts <- function(counts, thresh=32767, skipchecks=FALSE) {
  
  # If skipchecks=FALSE, perform data quality checks
  if (skipchecks==FALSE) {
    
    # If thresh out of range, output error
    if (thresh<=0) {
      stop("For thresh= option, please enter integer greater than 0")
    }
    
    # If counts is a character, output error
    if (is.character(counts)) {
      stop("For counts= option, please enter a vector or single-column matrix or data frame")
    }
    
    # If counts is a matrix or data frame and has multiple columns, output error
    if (is.matrix(counts) | is.data.frame(counts)) {
      if (ncol(counts)>1) {
        stop("For counts= option, please enter vector or single-column matrix or data frame")
      }
    }
    
    # If counts is a data frame or matrix, convert to vector
    if (is.data.frame(counts)) {counts = as.vector(as.matrix(counts))}
    if (is.matrix(counts)) {counts = as.vector(counts)}
    
    # If any count values are less than 0, output error
    if (sum(counts<0)>0) {
      stop("For counts= option, please ensure that all values of object are non-negative")
    }
    
  }
  
  # Convert counts to vector of integers (if not already)
  if (!is.integer(counts)) {counts = as.integer(counts)}
  
  # Pass values to C++ function artifacts
  .Call('accelerometry_artifacts', PACKAGE = 'accelerometry', counts, thresh)
}

accel.bouts <- function(counts, weartime=NULL, bout.length=10, thresh.lower=0, thresh.upper=Inf, 
                        tol=0, tol.lower=0, tol.upper=Inf, nci=FALSE, days.distinct=FALSE, skipchecks=FALSE) {
  
  # If skipchecks=FALSE, perform data quality checks
  if (skipchecks==FALSE) {
    
    # If any numeric options are out of range, output error
    if (bout.length < 0 | thresh.lower < 0 | thresh.upper < 0 | tol < 0 | 
          tol.lower < 0 | tol.upper < 0) {
      stop("For bout.length= , thresh.lower= , thresh.upper= , tol = ,
             tol.lower= , and tol.upper= options, please enter
             non-negative values")
    }
    
    # If counts is a character, output error
    if (is.character(counts)) {
      stop("For counts= option, please enter a vector or single-column matrix or data frame")
    }
    
    # If counts is a matrix or data frame and has multiple columns, output error
    if (is.matrix(counts) | is.data.frame(counts)) {
      if (ncol(counts)>1) {
        stop("For counts= option, please enter vector or single-column matrix or data frame")
      }
    }
    
    # If counts is a data frame or matrix, convert to vector
    if (is.data.frame(counts)) {counts = as.vector(as.matrix(counts))}
    if (is.matrix(counts)) {counts = as.vector(counts)}
    
    # If any count values are less than 0, output error
    if (sum(counts<0)>0) {
      stop("For counts= option, please ensure that all values of object are non-negative")
    }
    
    # If weartime is NULL, define as vector of 1's
    if (is.null(weartime)) {
      weartime = as.integer(rep(1,length(counts)))
    }
    
    # If weartime is a matrix or data frame and has multiple columns, output error
    if (is.matrix(weartime) | is.data.frame(weartime)) {
      if (ncol(weartime)>1) {
        stop("For weartime= option, please enter object with no more than 1 column")
      }
    }
    
    # If weartime is a data frame or matrix, convert to vector of integers
    if (is.data.frame(weartime)) {weartime = as.matrix(weartime)}
    weartime = as.integer(weartime)
    
    # If any weartime values are not 0 or 1, output error
    if (sum(weartime!=0 & weartime!=1)) {
      stop("For weartime= option, please enter object consisting of only 0's and 1's")
    }
    
    # If length of counts vector and weartime vector differ, output error
    if (length(counts)!=length(weartime)) {
      stop("For counts= and weartime= options, please enter Objects of same length")
    }
    
    # If bout.length is greater than or equal to length(counts), output error
    if (bout.length>=length(counts)) {
      stop("For bout.length= option, please enter value smaller than length(counts)")
    }
    
    # If tol is greater than or equal to bout.length, output error
    if (tol>=bout.length) {
      stop("For tol= option, please enter value smaller than bout.length")
    }
    
    # If neither thresh.lower nor thresh.upper are specified, output error
    if (thresh.lower==0 & thresh.upper==Inf) {
      stop("Please enter values for thresh.lower, thresh.upper, or both")
    }
    
    # If nci is not a logical, output error
    if (!is.logical(nci)) {
      stop("For nci= , please enter either TRUE or FALSE")
    }
    
    # If days.distinct is not a logical, output error
    if (!is.logical(days.distinct)) {
      stop("For days.distinct= option, please enter either TRUE or FALSE")
    }
    
    # If tol>0, nci=FALSE, and tol.lower=0, output warning
    if (tol>0 & nci==FALSE & tol.lower==0) {
      warning("Specifying a non-zero for tol.lower is highly recommended;
                otherwise, bout durations will frequently be over-estimated")
    }
    
  }
  
  # If upper thresholds are set to Inf, change to 1 million for purposes of C++ code
  if (thresh.upper==Inf) {thresh.upper = 1000000}
  if (tol.upper==Inf) {tol.upper = 1000000}
  
  # Convert counts and weartime to vectors of integers (if not already)
  if (!is.integer(counts)) {counts = as.integer(counts)}
  if (!is.integer(weartime)) {weartime = as.integer(weartime)}
  
  # Convert nci values of TRUE/FALSE to 1/0
  if (nci==TRUE) {nci=1} else if (nci==FALSE) {nci=0}
  
  # Convert days.distinct values of TRUE/FALSE to 1/0
  if (days.distinct==TRUE) {days.distinct=1} else if (days.distinct==FALSE) {days.distinct=0}
  
  # Pass values to C++ function bouts
  .Call('accelerometry_bouts', PACKAGE = 'accelerometry', counts, weartime, bout.length, thresh.lower, thresh.upper, tol, tol.lower, tol.upper, nci, days.distinct)
}

accel.intensities <- function(counts, thresh=c(100,760,2020,5999), skipchecks=FALSE) {
  
  # If skipchecks=FALSE, perform data quality checks
  if (skipchecks==FALSE) {
    
    # If thresh is not a vector of length 4 or has values out of range, output error
    if (length(thresh)!=4 | min(thresh)<=0) {
      stop("For thresh= option, please enter a vector of 4 positive integers")
    }
    
    # If counts is a character, output error
    if (is.character(counts)) {
      stop("For counts= option, please enter a vector or single-column matrix or data frame")
    }
    
    # If counts is a matrix or data frame and has multiple columns, output error
    if (is.matrix(counts) | is.data.frame(counts)) {
      if (ncol(counts)>1) {
        stop("For counts= option, please enter vector or single-column matrix or data frame")
      }
    }
    
    # If counts is a data frame or matrix, convert to vector
    if (is.data.frame(counts)) {counts = as.vector(as.matrix(counts))}
    if (is.matrix(counts)) {counts = as.vector(counts)}
    
    # If any count values are less than 0, output error
    if (sum(counts<0)>0) {
      stop("For counts= option, please ensure that all values of object are non-negative")
    }
    
  }
  
  # Convert counts and weartime to vectors of integers (if not already)
  if (!is.integer(counts)) {counts = as.integer(counts)}
  
  # Pass values to C++ function intensities_c
  .Call('accelerometry_intensities', PACKAGE = 'accelerometry', counts, thresh)
}

accel.sedbreaks <- function(counts, weartime=NULL, thresh=100, return.flags=FALSE, skipchecks=FALSE) {
  
  # If skipchecks=FALSE, perform data quality checks
  if (skipchecks==FALSE) {
    
    # If any numeric options are out of range, output error
    if (thresh<1) {
      stop("For sed.break.cutpoint= option, please enter integer greater than 0")
    }
    
    # If counts is a character, output error
    if (is.character(counts)) {
      stop("For counts= option, please enter a vector or single-column matrix or data frame")
    }
    
    # If counts is a matrix or data frame and has multiple columns, output error
    if (is.matrix(counts) | is.data.frame(counts)) {
      if (ncol(counts)>1) {
        stop("For counts= option, please enter vector or single-column matrix or data frame")
      }
    }
    
    # If counts is a data frame or matrix, convert to vector
    if (is.data.frame(counts)) {counts = as.vector(as.matrix(counts))}
    if (is.matrix(counts)) {counts = as.vector(counts)}
    
    # If any count values are less than 0, output error
    if (sum(counts<0)>0) {
      stop("For counts= option, please ensure that all values of object are non-negative")
    }
    
    # If weartime is NULL, define as vector of 1's
    if (is.null(weartime)) {
      weartime = as.integer(rep(1,length(counts)))
    }
    
    # If weartime is a matrix or data frame and has multiple columns, output error
    if (is.matrix(weartime) | is.data.frame(weartime)) {
      if (ncol(weartime)>1) {
        stop("For weartime= option, please enter object with no more than 1 column")
      }
    }
    
    # If weartime is a data frame or matrix, convert to vector of integers
    if (is.data.frame(weartime)) {weartime = as.matrix(weartime)}
    weartime = as.integer(weartime)
    
    # If any weartime values are not 0 or 1, output error
    if (sum(weartime!=0 & weartime!=1)) {
      stop("For weartime= option, please enter object consisting of only 0's and 1's")
    }
    
    # If length of counts vector and weartime vector differ, output error
    if (length(counts)!=length(weartime)) {
      stop("For counts= and weartime= options, please enter Objects with same length")
    }
    
    # If return.flags is not a logical, output error
    if (!is.logical(return.flags)) {
      stop("For return.logical= , please enter either TRUE or FALSE")
    }
  }
  
  # Convert counts and weartime to vectors of integers (if not already)
  if (!is.integer(counts)) {counts = as.integer(counts)}
  if (!is.integer(weartime)) {weartime = as.integer(weartime)}
  
  # Pass values to C++ function sedbreaks_c
  if (return.flags==FALSE) {.Call('accelerometry_sedbreaks', PACKAGE = 'accelerometry', counts, weartime, thresh)}
  else {.Call('accelerometry_sedbreaks_flags', PACKAGE = 'accelerometry', counts, weartime, thresh)}
  
}

accel.weartime <- function(counts, window=60, tol=0, tol.upper=99, nci=FALSE, days.distinct=FALSE, skipchecks=FALSE) {
  
  # If skipchecks=FALSE, perform data quality checks
  if (skipchecks==FALSE) {
    
    # If any numeric options are out of range, output error
    if (window<=0 | tol<0 | tol.upper<0) {
      stop("window, tol, and tol.upper must be non-negative integers")
    }
    
    # If any count values are less than 0, output error
    if (sum(counts<0)>0) {
      stop("All count values must be non-negative")
    }
    
    # If counts is a matrix or data frame and has multiple columns, output error
    if (is.matrix(counts) | is.data.frame(counts)) {
      if (ncol(counts)>1) {
        stop("For counts= option, please enter a vector or single-column matrix or data frame")
      }
    }
    
    # If counts is a data frame or matrix, convert to vector
    if (is.data.frame(counts)) {counts = as.vector(as.matrix(counts))}
    if (is.matrix(counts)) {counts = as.vector(counts)}
    
    # If window is greater than length(counts), output error
    if (window>length(counts)) {
      stop("window must be no greater than length(counts)")
    }
    
    # If tol is greater than or equal to window, output error
    if (tol>=window) {
      stop("tol must be smaller than window")
    }
    
    # If nci is not a logical, output error
    if (!is.logical(nci)) {
      stop("For nci= option, please enter either TRUE or FALSE")
    }
    
    # If days.distinct is not a logical, output error
    if (!is.logical(days.distinct)) {
      stop("For days.distinct= option, please enter either TRUE or FALSE")
    }
    
  }
  
  # Convert counts to vector of integers (if not already)
  if (!is.integer(counts)) {counts = as.integer(counts)}
  
  # Convert nci values of TRUE/FALSE to 1/0
  if (nci==TRUE) {nci=1} else if (nci==FALSE) {nci=0}
  
  # Convert days.distinct values of TRUE/FALSE to 1/0
  if (days.distinct==TRUE) {days.distinct=1} else if (days.distinct==FALSE) {days.distinct=0}
  
  # Pass values to C++ function weartime
  .Call('accelerometry_weartime', PACKAGE = 'accelerometry', counts, window, tol, tol.upper, nci, days.distinct)
  
}

movingaves <- function(x, window, return.max=FALSE, skipchecks=FALSE) {
  
  # If skipchecks=FALSE, perform data quality checks
  if (skipchecks==FALSE) {
    
    # If window is out of range, output error
    if (window<=1) {
      stop("For window= option, please enter integer greater than 1")
    }
    
    # If x is a character, output error
    if (is.character(x)) {
      stop("For x= option, please enter a vector or single-column matrix or data frame")
    }
    
    # If x is a matrix or data frame and has multiple columns, output error
    if (is.matrix(x) | is.data.frame(x)) {
      if (ncol(x)>1) {
        stop("For x= option, please enter vector or single-column matrix or data frame")
      }
    }
    
    # If x is a data frame or matrix, convert to vector
    if (is.data.frame(x)) {x = as.vector(as.matrix(x))}
    if (is.matrix(x)) {x = as.vector(x)}
    
    # If window is greater than length of x, output error
    if (window>length(x)) {
      stop("For window= option, please enter a value no greater than length(x)")
    }
    
    # If return.max is not a logical, output error
    if (!is.logical(return.max)) {
      stop("For return.max= , please enter either TRUE or FALSE")
    }
    
  }
  
  # Pass values to appropriate C++ function, depending on return.max
  if (return.max==FALSE) {.Call('accelerometry_movingaves', PACKAGE = 'accelerometry', x, window)}
  else {.Call('accelerometry_movingaves_max', PACKAGE = 'accelerometry', x, window)}
  
}

blockaves <- function(x, window, skipchecks=FALSE) {
  
  # If skipchecks=FALSE, perform data quality checks
  if (skipchecks==FALSE) {
    
    # If window is out of range, output error
    if (window<=1) {
      stop("For window= option, please enter integer greater than 1")
    }
    
    # If x is a character, output error
    if (is.character(x)) {
      stop("For x= option, please enter a vector or single-column matrix or data frame")
    }
    
    # If x is a matrix or data frame and has multiple columns, output error
    if (is.matrix(x) | is.data.frame(x)) {
      if (ncol(x)>1) {
        stop("For x= option, please enter vector or single-column matrix or data frame")
      }
    }
    
    # If x is a data frame or matrix, convert to vector
    if (is.data.frame(x)) {x = as.vector(as.matrix(x))}
    if (is.matrix(x)) {x = as.vector(x)}
    
    # If window is greater than length of x, output error
    if (window>length(x)) {
      stop("For window= option, please enter a value no greater than length(x)")
    }
    
  }
  
  # Pass values to C++ function blockaves
  .Call('accelerometry_blockaves', PACKAGE = 'accelerometry', x, window)
  
}

personvars <- function(dayvars, rows, days, wk, we) {
  .Call('accelerometry_personvars', PACKAGE = 'accelerometry', dayvars, rows, days, wk, we)
}

rle2.num <- function(x, nmax) {
  .Call('accelerometry_rle2_num', PACKAGE = 'accelerometry', x, nmax)
}

rle2.char <- function(x, nmax) {
  .Call('accelerometry_rle2_char', PACKAGE = 'accelerometry', x, nmax)
}

rle2 <- function(x) {
  
  # If x is a matrix or data frame and has multiple columns, output error
  if (is.matrix(x) | is.data.frame(x)) {
    if (ncol(x)>1) {
      stop("For x= option, please enter vector or single-column matrix or data frame (can be numeric or character)")
    }
  }
  
  # Get class of x and output error if not numeric or character
  if (is.numeric(x)) {
    class_x = 1
  } else if (is.character(x)) {
    class_x = 2
  } else {
    stop("For x= option, please enter vector or single-column matrix or data frame (can be numeric or character)")
  }
  
  # Get length of x
  length_x = length(x)
  
  # If length is 10k or less, use simplest version of algorithm
  if (length_x<=10000) {
    if (class_x==1) {
      out = rle2.num(x=x, nmax=-1)
    } else {
      out = rle2.char(x=x, nmax=-1)
    }
  }
  
  # Else use a faster method (up to 2x as fast)
  else {
    
    # Calculate end point for first 0.1% of data in x
    end_partial = ceiling(length_x/1000)
    
    # Send first 0.1% of x to C++ function
    if (class_x==1) {
      partial = rle2.num(x=x[1:end_partial], nmax=-1)
    } else {
      partial = rle2.char(x=x[1:end_partial], nmax=-1)
    }
    
    # Calculate number of rows in out_partial
    rows = nrow(partial)
    
    # If average less than 2 data points per interval, use simplest version of algorithm
    if (rows/end_partial>0.5) {
      
      if (class_x==1) {
        out = rle2.num(x=x, nmax=-1)
      } else {
        out = rle2.char(x=x, nmax=-1)
      }
      
    }
    
    # Otherwise, estimate the number of rows and use faster algorithm
    else {
      
      # Set nmax according to number of segments in first 0.1% of data
      nmax = rows*1000*1.1
      
      # Send x to rle2_c, and confirm that nmax was sufficiently high
      repeat {
        
        if (class_x==1) {
          out = rle2.num(x=x, nmax=nmax)
        } else {
          out = rle2.char(x=x, nmax=nmax)
        }
        
        if (nrow(out)<nmax) {
          break
        }
        else {
          nmax = nmax*10
        }
      }
      
    }
    
  }
  
  # If x was character, convert output matrix to a data frame
  if (class_x==2) {
    out = cbind(as.data.frame(x=cbind(out[,1]), stringsAsFactors=FALSE), 
                as.numeric(out[,2]), as.numeric(out[,3]), as.numeric(out[,4]))
  }
  
  # Add column names
  colnames(out) = c("value","start","stop","length")
  
  return(out)
  
}

accel.process <- function(counts, steps=NULL, days=NULL, id=NULL, brevity=1, valid.days=1,
                         valid.week.days=0, valid.weekend.days=0, int.cuts=c(100,760,2020,5999),
                         days.distinct=FALSE, nonwear.window=60, nonwear.tol=0, nonwear.tol.upper=99,
                         nonwear.nci=FALSE, weartime.minimum=600, weartime.maximum=1200,
                         use.partialdays=FALSE, active.bout.length=10, active.bout.tol=0,
                         mvpa.bout.tol.lower=0, vig.bout.tol.lower=0, active.bout.nci=FALSE,
                         sed.bout.tol=0, sed.bout.tol.maximum=int.cuts[2]-1, artifact.thresh = 25000,
                         artifact.action = 1, return.averages=FALSE, weekday.weekend=FALSE,
                         skipchecks=FALSE) {
  
  # If skipchecks=FALSE, perform data quality checks
  if (skipchecks==FALSE) {
    
    # If counts is a character, output error
    if (is.character(counts)) {
      stop("For counts= option, please enter a vector or single-column matrix or data frame")
    }
    
    # If counts is a matrix or data frame and has multiple columns, output error
    if (is.matrix(counts) | is.data.frame(counts)) {
      if (ncol(counts)>1) {
        stop("For counts= option, please enter vector or single-column matrix or data frame")
      }
    }
    
    # If counts is a data frame or matrix, convert to vector
    if (is.data.frame(counts)) {counts = as.vector(as.matrix(counts))}
    if (is.matrix(counts)) {counts = as.vector(counts)}
    
    # If any count values are less than 0, output error
    if (sum(counts<0)>0) {
      stop("For counts= option, please ensure that all values of object are non-negative")
    }
    
    # If length of counts is less than 1440, output error
    if (length(counts)<1440) {
      stop("For counts= option, please ensure there is at least 1 full day of data (1440 data points)")
    }
    
    # If steps is a matrix or data frame and has multiple columns, output error
    if (is.matrix(steps) | is.data.frame(steps)) {
      if (ncol(steps)>1) {
        stop("For steps= option, please either enter vector or single-column matrix or data frame (or omit)")
      }
    }
    
    # If steps is a data frame or matrix, convert to vector
    if (is.data.frame(steps)) {steps = as.vector(as.matrix(steps))}
    if (is.matrix(steps)) {steps = as.vector(steps)}
    
    # If any step values are less than 0, output error
    if (sum(steps<0)>0) {
      stop("For steps= option, please ensure that all values of object are non-negative")
    }
    
    # If length of steps and counts vectors are different, output error
    if (!is.null(steps) & length(steps)!=length(counts)) {
      stop("For counts= and steps= options, please enter objects of same length")
    }
    
    # If more than one id, output error
    if (!is.null(id) & length(unique(id))>1) {
      stop("For id= option, please enter either a single ID number or a vector with repeated value of a single ID number")
    }
    
    # If brevity out of range, output error
    if (sum(brevity==c(1,2,3))==0) {
      stop("For brevity= option, please enter 1, 2, or 3 (see documentation)")
    }
    
    # If valid.days, valid.week.days, or valid.weekend.days out of range, output error
    if (valid.days<1 | valid.days>7 | valid.week.days>5 | valid.weekend.days > 2) {
      stop("For valid.days= option, please enter value between 1 and 7; for valid.week.days= 
           and valid.weekend.days= options, please enter values no greater than 5 and 2, 
           respectively")
    }
    
    # If length of int.cuts is not 4, or if values are out of range, output error
    if (length(int.cuts)!=4 | sum(int.cuts<0)>0) {
      stop("For int.cuts= option, please enter a vector of 4 non-negative values")
    }
    
    # If days.distinct is not a logical, output error
    if (!is.logical(days.distinct)) {
      stop("For days.distinct= option, please enter TRUE or FALSE")
    }
    
    # If If nonwear.window is out of range, output error
    if (nonwear.window<1) {
      stop("For nonwear.window= option, please enter positive value")
    }
    
    # If nonwear.tol out of range, output error
    if (nonwear.tol<0 | nonwear.tol>=nonwear.window) {
      stop("For nonwear.tol= option, please enter non-negative value less than nonwear.window")
    }
    
    # If nonwear.tol.upper out of range, output error
    if (nonwear.tol.upper<0) {
      stop("For nonwear.tol.upper= option, please enter non-negative value")
    }
    
    # If nonwear.nci is not a logical, output error
    if (!is.logical(nonwear.nci)) {
      stop("For nonwear.nci= option, please enter TRUE or FALSE")
    }
    
    # If weartime.minimum out of range, output error
    if (weartime.minimum <=0) {
      stop("For weartime.minimum= option, please enter positive value")
    }
    
    # If weartime.maximum out of range, output error
    if (weartime.maximum<=weartime.minimum) {
      stop("For weartime.maximum= option, please enter positive value greater than weartime.minimum")
    }
    
    # If use.partialdays is not a logical, output error
    if (!is.logical(use.partialdays)) {
      stop("For use.partialdays= option, please enter TRUE or FALSE")
    }
    
    # If active.bout.length out of range, output error
    if (active.bout.length<=1) {
      stop("For active.bout.length= option, please enter value greater than 1")
    }
    
    # If active.bout.tol out of range, output error
    if (active.bout.tol<0 | active.bout.tol>=active.bout.length) {
      stop("For active.bout.tol= option, please enter non-negative value less than active.bout.tol")
    }
    
    # If mvpa.bout.tol.lower out of range, output error
    if (mvpa.bout.tol.lower<0 | mvpa.bout.tol.lower>int.cuts[3]) {
      stop("For mvpa.bout.tol.lower= option, please enter non-negative value no greater than int.cuts[3]")
    }
    
    # If vig.bout.tol.lower out of range, output error
    if (vig.bout.tol.lower<0 | vig.bout.tol.lower>int.cuts[4]) {
      stop("For vig.bout.tol.lower= option, please enter non-negative value no greater than int.cuts[4]")
    }
    
    # If active.bout.nci is not a logical, output error
    if (!is.logical(active.bout.nci)) {
      stop("For active.bout.nci= option, please enter TRUE or FALSE")
    }
    
    # If sed.bout.tol out of range, output error
    if (sed.bout.tol<0 | sed.bout.tol>=10) {
      stop("For sed.bout.tol= option, please enter non-negative value less than 10")
    }
    
    # If sed.bout.tol.maximum out of range, output error
    if (sed.bout.tol.maximum<0) {
      stop("For sed.tol.maximum= option, please enter non-negative value")
    }
    
    # If artifact.thresh out of range, output error
    if (artifact.thresh <= int.cuts[4]) {
      stop("For artifact.thresh= option, please enter value greater than int.cuts[4]")
    }
    
    # If artifact.action out of range, output error
    if (sum(artifact.action==c(1,2,3,4))==0) {
      stop("For artifact.action= option, please enter 1, 2, 3, or 4 (see documentation)")
    }
    
    # If return.averages is not a logical, output error
    if (!is.logical(return.averages)) {
      stop("For return.averages= option, please enter TRUE or FALSE")
    }
    
    # If weekday.weekend is not a logical, output error
    if (!is.logical(weekday.weekend)) {
      stop("For weekday.weekend= option, please enter TRUE or FALSE")
    }
    
  }
  
  # Get values that will be used more than once
  datalength = length(counts)
  
  # If days vector not provided, assign day 1 = 1-1440, day 2 = 1441-2880, etc.
  if (is.null(days)) {
    days = rep(NA,datalength)
    for (j in 1:ceiling(datalength/1440)) {
      days[(1440*j-1439):min(1440*j,datalength)] = ceiling(j%%7.1)
    }
  }
  
  # If id value or vector is provided, get first value
  if (is.null(id)) {id = 1} else {id = id[1]}
  
  # Finding start and end points of each day
  mat = rle2(x=days)
  
  # Initializing matrix to save daily physical activity variables
  dayvars = matrix(NA,ncol=66,nrow=nrow(mat))
  
  # k is the "day counter"
  k = 0
  
  # If artifact.action = 3, replace minutes with counts > artifact.thresh with average of surrounding minutes
  if (artifact.action==3) {counts = accel.artifacts(counts=counts,thresh=artifact.thresh)}
  
  # Call weartime.flag function to flag minutes valid for analysis
  wearflag = accel.weartime(counts=counts,
                            window=nonwear.window,
                            tol=nonwear.tol,
                            tol.upper=nonwear.tol.upper,
                            nci=nonwear.nci,
                            days.distinct=days.distinct)
  
  # If artifact.action = 2, consider minutes with counts >= artifact.thresh as non-weartime
  if (artifact.action==2) {
    artifact.locs = which(counts>=artifact.thresh)
    wearflag[artifact.locs] = 0
    counts[artifact.locs] = 0
  }
  
  # Identify bouts of MVPA, VPA, and sedentary time
  if (brevity==2 | brevity==3) {
    boutedMVPA = accel.bouts(counts=counts,
                             weartime=wearflag,
                             bout.length=active.bout.length,
                             thresh.lower=int.cuts[3],
                             tol=active.bout.tol,
                             tol.lower=mvpa.bout.tol.lower,
                             nci=active.bout.nci,
                             days.distinct=days.distinct,
                             skipchecks=TRUE)
    boutedvig = accel.bouts(counts=counts,
                            weartime=wearflag,
                            bout.length=active.bout.length,
                            thresh.lower=int.cuts[4],
                            tol=active.bout.tol,
                            tol.lower=vig.bout.tol.lower,
                            nci=active.bout.nci,
                            days.distinct=days.distinct,
                            skipchecks=TRUE)
    boutedsed10 = accel.bouts(counts=counts,
                              weartime=wearflag,
                              bout.length=10,
                              thresh.upper=int.cuts[1]-1,
                              tol=sed.bout.tol,
                              tol.upper=sed.bout.tol.maximum,
                              days.distinct=days.distinct,
                              skipchecks=TRUE)
    boutedsed30 = accel.bouts(counts=counts,
                              weartime=wearflag,
                              bout.length=30,
                              thresh.upper=int.cuts[1]-1,
                              tol=sed.bout.tol,
                              tol.upper=sed.bout.tol.maximum,
                              days.distinct=days.distinct,
                              skipchecks=TRUE)
    boutedsed60 = accel.bouts(counts=counts,
                              weartime=wearflag,
                              bout.length=60,
                              thresh.upper=int.cuts[1]-1,
                              tol=sed.bout.tol,
                              tol.upper=sed.bout.tol.maximum,
                              days.distinct=days.distinct,
                              skipchecks=TRUE)
  }
  
  # Looping through accelerometer data for i days
  for (i in 1:nrow(mat)) { 
    
    # Row index for physical activity variable matrix
    k = k + 1
    
    # Loading accelerometer data from day i
    day.counts = counts[mat[i,2]:mat[i,3]]
    day.wearflag = wearflag[mat[i,2]:mat[i,3]]
    if (brevity==2 | brevity==3) {
      day.boutedMVPA = boutedMVPA[mat[i,2]:mat[i,3]]
      day.boutedvig = boutedvig[mat[i,2]:mat[i,3]]
      day.boutedsed10 = boutedsed10[mat[i,2]:mat[i,3]]
      day.boutedsed30 = boutedsed30[mat[i,2]:mat[i,3]]
      day.boutedsed60 = boutedsed60[mat[i,2]:mat[i,3]]
    }
    if (!is.null(steps)) {day.steps = steps[mat[i,2]:mat[i,3]]}
    
    # Calculating constants that are used more than once
    daywear = sum(day.wearflag)
    maxcount = max(day.counts)
    daylength = length(day.counts)
    
    # ID number
    dayvars[k,1] = id
    
    # Day of week
    dayvars[k,2] = mat[i,1]
    
    # Check whether day is valid for analysis; if not, mark as invalid
    if (daywear<weartime.minimum | daywear>weartime.maximum | (artifact.action==1 & maxcount>=artifact.thresh) |
          (use.partialdays==FALSE & daylength<1440)) {
      dayvars[k,3] = 0
    } else {dayvars[k,3] = 1}
    
    # Minutes of valid wear time
    dayvars[k,4] = daywear
    
    # Storing day.counts[day.wearflag==1] into its own vector
    day.counts.valid = day.counts[day.wearflag==1]
    
    # Total counts during wear time
    dayvars[k,5] = sum(day.counts.valid)
    
    # Counts per minute - calculated as total counts during wear time divided by wear time
    dayvars[k,6] = dayvars[k,5]/dayvars[k,4]
    
    if (brevity==2 | brevity==3) {
      
      # Steps
      if (!is.null(steps)) {dayvars[k,7] = sum(day.steps[day.wearflag==1])}
      
      # Minutes in various intensity levels
      intensities = accel.intensities(counts=day.counts.valid,thresh=int.cuts)
      dayvars[k,8:15] = intensities[1:8]
      
      # Proportions of daily wear time in each intensity level
      dayvars[k,16:23] = dayvars[k,8:15]/daywear
      
      # Counts accumulated during wear time in each intensity level  
      dayvars[k,24:31] = intensities[9:16]
      
      # Bouted sedentary time
      dayvars[k,32] = sum(day.boutedsed10)
      dayvars[k,33] = sum(day.boutedsed30)
      dayvars[k,34] = sum(day.boutedsed60)
      
      # Sedentary breaks
      dayvars[k,35] = accel.sedbreaks(counts=day.counts,weartime=day.wearflag,thresh=int.cuts[1],skipchecks=TRUE)
      
      # Maximum 1-min, 5-min, 10-min, and 30-min count averages
      dayvars[k,36] = maxcount
      dayvars[k,37] = movingaves(x=day.counts,window=5,return.max=TRUE,skipchecks=TRUE)
      dayvars[k,38] = movingaves(x=day.counts,window=10,return.max=TRUE,skipchecks=TRUE)
      dayvars[k,39] = movingaves(x=day.counts,window=30,return.max=TRUE,skipchecks=TRUE)
      
      # MVPA and vigorous physical activity in >= 10-min bouts
      dayvars[k,40] = sum(day.boutedMVPA)
      dayvars[k,41] = sum(day.boutedvig)
      dayvars[k,42] = sum(dayvars[k,40:41])
      
      if (brevity==3) {
        
        # Hourly counts/min averages
        if (daylength==1440) {
          dayvars[k,43:66] = blockaves(x=day.counts,window=60,skipchecks=TRUE)
        }
        
      }
    }
    
  }
  
  # Return matrix of daily physical activity variables or row vector of daily averages
  if (return.averages==FALSE) {
    
    colnames(dayvars) = c("id","day","valid_day","valid_min","counts","cpm","steps","sed_min","light_min","life_min",
                          "mod_min","vig_min","lightlife_min","mvpa_min","active_min","sed_percent","light_percent",
                          "life_percent","mod_percent","vig_percent","lightlife_percent","mvpa_percent","active_percent",
                          "sed_counts","light_counts","life_counts","mod_counts","vig_counts","lightlife_counts",
                          "mvpa_counts","active_counts","sed_bouted_10min","sed_bouted_30min","sed_bouted_60min",
                          "sed_breaks","max_1min_counts","max_5min_counts","max_10min_counts","max_30min_counts",
                          "mvpa_bouted","vig_bouted","guideline_min","cpm_hour1","cpm_hour2","cpm_hour3","cpm_hour4",
                          "cpm_hour5","cpm_hour6","cpm_hour7","cpm_hour8","cpm_hour9","cpm_hour10","cpm_hour11",
                          "cpm_hour12","cpm_hour13","cpm_hour14","cpm_hour15","cpm_hour16","cpm_hour17","cpm_hour18",
                          "cpm_hour19","cpm_hour20","cpm_hour21","cpm_hour22","cpm_hour23","cpm_hour24")
    
    # Drop variables according to brevity setting
    if (brevity==1) {dayvars = dayvars[,1:6]}
    else if (brevity==2) {dayvars = dayvars[,1:42]}
    if (brevity>1 & is.null(steps)) {dayvars = dayvars[,c(1:6,8:ncol(dayvars))]}
    
    return(dayvars)
    
  } else {
    
    # Calculate daily averages
    averages = personvars(dayvars=dayvars,rows=1,days=valid.days,wk=valid.week.days,we=valid.weekend.days)
    
    # Assign variable names
    varnames = c("id","valid_days","valid_week_days","valid_weekend_days","include",
                 "valid_min","counts","cpm","steps","sed_min","light_min",
                 "life_min","mod_min","vig_min","lightlife_min","mvpa_min",
                 "active_min","sed_percent","light_percent","life_percent",
                 "mod_percent","vig_percent","lightlife_percent","mvpa_percent",
                 "active_percent","sed_counts","light_counts","life_counts",
                 "mod_counts","vig_counts","lightlife_counts","mvpa_counts",
                 "active_counts","sed_bouted_10min","sed_bouted_30min",
                 "sed_bouted_60min","sed_breaks","max_1min_counts","max_5min_counts",
                 "max_10min_counts","max_30min_counts","mvpa_bouted","vig_bouted",
                 "guideline_min","cpm_hour1","cpm_hour2","cpm_hour3","cpm_hour4",
                 "cpm_hour5","cpm_hour6","cpm_hour7","cpm_hour8","cpm_hour9","cpm_hour10","cpm_hour11",
                 "cpm_hour12","cpm_hour13","cpm_hour14","cpm_hour15","cpm_hour16","cpm_hour17","cpm_hour18",
                 "cpm_hour19","cpm_hour20","cpm_hour21","cpm_hour22","cpm_hour23","cpm_hour24")
    varnames = c(varnames,paste("wk_",varnames[6:68],sep=""),paste("we_",varnames[6:68],sep=""))
    colnames(averages) = varnames
    
    # Drop variables according to brevity and weekday.weekend settings
    if (brevity==1) {
      if (weekday.weekend==TRUE) {averages = averages[,c(1:8,69:71,132:134)]}
      else {averages = averages[,c(1:8)]}
    } else if (brevity==2) {
      if (weekday.weekend==TRUE) {
        if (is.null(steps)) {averages = averages[,c(1:8,10:44,69:71,73:107,132:134,136:170)]}
        else {averages = averages[,c(1:44,69:107,132:170)]}
      }
      else {
        if (is.null(steps)) {averages = averages[,c(1:8,10:44)]}
        else {averages = averages[,1:44]}
      }
    } else if (brevity==3) {
      if (weekday.weekend==TRUE) {
        if (is.null(steps)) {averages = averages[,c(1:8,10:71,73:134,136:194)]}
      }
      else {
        if (is.null(steps)) {averages = averages[,c(1:8,10:68)]}
        else {averages = averages[,1:68]}
      }
    }
    
    return(averages)
    
  }
  
}