% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worldplotCat.R
\name{worldplotCat}
\alias{worldplotCat}
\title{worldplotCat}
\usage{
worldplotCat(
  data,
  ColName,
  CountryName,
  CountryNameType,
  longitude = c(-180, 180),
  latitude = c(-90, 90),
  title = "",
  legendTitle = as.character(ColName),
  Categories = levels(factor(map_df$MapFiller)),
  na.as.category = TRUE,
  annote = FALSE,
  div = 1,
  palette_option = "D",
  save = FALSE,
  filename = "worldplot.jpg",
  path = tempdir(),
  width = 20,
  height = 10,
  units = "cm",
  scale = 1
)
}
\arguments{
\item{data}{Data set containing the list of nations and the variable that we want to plot.}

\item{ColName}{Character variable with the name of the variable of interest.}

\item{CountryName}{Character variable with the name of the country names column.}

\item{CountryNameType}{Character variable with the coding for \code{CountryName}. One of \code{isoa2} (default), \code{isoa3}, or \code{name}.}

\item{longitude}{Longitude limits. Default is \code{c(-180, 180)} (whole world).}

\item{latitude}{Latitude limits. Default is \code{c(-90, 90)} (whole world).}

\item{title}{Title of the plot. Default is no title.}

\item{legendTitle}{Title of the legend. Default is the name of the filling variable.}

\item{Categories}{categories labels to be plotted in the legend.}

\item{na.as.category}{Treat \code{NA} as a separate category? If `\code{TRUE}, NA will also appear in the legend as one of the categories.}

\item{annote}{Do you want to plot country labels (ISO 3166-1 alpha-2 code) on the map? Default is set to \code{FALSE}.}

\item{div}{Parameter for modifying the elements dimensions in the map. Usually, it does not need to be modified. Default value is 1.}

\item{palette_option}{Character string indicating the palette to be used. Available options range between "A" and "H". You can also enter a string with a colour for each category}

\item{save}{Save the plot in a jpg file?}

\item{filename}{Only if is save set to \code{TRUE}. Name of the file.}

\item{path}{Only if save is set to \code{TRUE}. Path of the directory where the file is to be saved.}

\item{width}{Only if save is set to \code{TRUE}. Width of the file.}

\item{height}{Only if save is set to \code{TRUE}. Height of the file.}

\item{units}{Only if save is set to \code{TRUE}. Units for width and height. Can be 'cm', 'mm', 'in', or 'px'.}

\item{scale}{Only if save is set to \code{TRUE}. Scaling factor for adjusting image dimensions.}
}
\value{
a map
}
\description{
Plot a world heat map based on a categorical variable.
}
\examples{
data(testdata1b)
worldplotCat(data = testdata1b,
             div = 1,
             ColName = "VCat",
             CountryName = "Cshort",
             CountryNameType = "isoa2",
             annote = FALSE)

}
