% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDensity.R
\name{plotDensity}
\alias{plotDensity}
\title{Enhanced density plot for WordPools}
\usage{
plotDensity(data, var, adjust = 1, lwd = 2, fill = rgb(1, 0, 0, 0.2),
  xlab = NULL, main = NULL, anno = FALSE, ...)
}
\arguments{
\item{data}{A data.frame}

\item{var}{Name of the variable to be plotted}

\item{adjust}{Adjustment factor for the bandwidth of the density estimate}

\item{lwd}{line width}

\item{fill}{Color to fill the area under the density estimate}

\item{xlab}{Label for the variable}

\item{main}{Title for plot}

\item{anno}{If \code{TRUE}}

\item{...}{Other arguments passed to \code{\link[stats]{plot.density}}}
}
\value{
Returns the result of \code{\link[stats]{density}}
}
\description{
Plots the distribution of a variable with a density estimate and a rug plot
}
\examples{
plotDensity(Paivio, "imagery", anno=TRUE)
plotDensity(Paivio, "imagery", anno=TRUE, adjust=1.5)
plotDensity(Paivio, "syl")

plotDensity(TWP, "imagery", anno=TRUE)
}
