% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical_simulation.r
\name{get_transform_names}
\alias{get_transform_names}
\title{Return labels for given transforms}
\usage{
get_transform_names(
  transforms,
  prefer_primitive = c("if_shorter", "never", "always")
)
}
\arguments{
\item{transforms}{A named list of objects of class \code{trans}
or class \code{transform}
(see function \code{trans_new} in package \code{scales})}

\item{prefer_primitive}{If "never", the function always returns the value of
the field \code{name} (except if this is missing).
If "always", the name of the called function is returned unless it cannot be
identified (in many cases, the transform will not be primitive).
If "if_shorter", the shorter option of the two above is returned if both can
be retrieved.}
}
\value{
A named vector of transforms names.
}
\description{
The function \code{\link{simbase_covar}} allows the specification of a
transform for one or more variables. The present function creates short
names for such transforms for use in labelling (by default, the labelling is
done by \code{\link{simbase_labeler}}).
}
\details{
The label of a transform could be the value of the field \code{name} from
each object of class \code{trans} (or \code{transform}),
but also the name of the transform
function itself, if it is a primitive function or just calls one function.

Each object of class \code{trans} (or \code{transform})
should have a field \code{name}
which can be returned by the present function.

The function examines the field \code{transform}.
If this field contains a primitive function (see \code{\link{is_primitive}}),
or if there is just one function call in the body of this \code{transform}
function, we can also return the name of this called function.

If there is no field \code{name} and no single function is called from the
function defined in the field \code{transform},
a generic function name \code{"f."} is returned.
}
\examples{
get_transform_names(list(a = scales::log_trans(), b = scales::boxcox_trans(0)));
get_transform_names(list(x = list(name = 'a very long name', transform = log, inverse = exp)))
}
