% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.mc.sem.power.curve}
\alias{wp.mc.sem.power.curve}
\title{Statistical Power Curve for Structural Equation Modeling / Mediation based on Monte Carlo Simulation}
\usage{
wp.mc.sem.power.curve(model, indirect = NULL, nobs = 100, type = "basic",
  nrep = 1000, nboot = 1000, alpha = 0.95, skewness = NULL,
  kurtosis = NULL, ovnames = NULL, se = "default",
  estimator = "default", parallel = "no",
  ncore = Sys.getenv("NUMBER_OF_PROCESSORS"), cl = NULL, ...)
}
\arguments{
\item{model}{Model specified using lavaan syntax. More about model specification can be found in \cite{Rosseel (2012)}.}

\item{indirect}{Indirect effect difined using lavaan syntax.}

\item{nobs}{Sample size. It is 100 by default.}

\item{type}{The method used to test the indirect effects (\code{'basic'} or \code{'boot'}). By default type='basic'.
The type 'basic' is to use Sobel test (see also \cite{wp.mc.sem.basic}), while 'boot' is to use bootstrap method (see also \cite{wp.mc.sem.boot}).}

\item{nrep}{Number of replications for the Monte Carlo simulation. It is 1000 by default.}

\item{nboot}{Number of replications for the bootstrap to test the specified parameter (e.g., mediation). It is 1000 by default.}

\item{alpha}{significance level chosed for the test. It equals 0.05 by default.}

\item{skewness}{A sequence of skewnesses of the observed variables. It is not required.}

\item{kurtosis}{A sequence of kurtosises of the observed variables. It is not required.}

\item{ovnames}{Names of the observed variables in the model. It is not required.}

\item{se}{The method for calculatating the standard errors. Its default method "default" is regular standard errors.
More about methods specification standard errors calculatationcan be found in \cite{Rosseel (2012)}.}

\item{estimator}{Estimator. It is Maxmum likelihood estimator by default. More about estimator specification can be found in \cite{Rosseel (2012)}.}

\item{parallel}{Parallel computing (\code{"no"} or \code{"parallel"} or \code{"snow"}). It is "no" by default, which means it will not use parallel computing.
The option "parallel" is to use multiple cores in a computer for parallel computing. It is used with the number of cores (\cite{ncore}).
The option "snow" is to use clusters for parallel computing. It is used with the number of clusters (\cite{cl}).}

\item{ncore}{Number of processors used for parallel computing. By default, ncore = Sys.getenv('NUMBER_OF_PROCESSORS').}

\item{cl}{Number of clusters. It is NULL by default. When it is NULL, the program will detect the number of clusters automatically.}

\item{...}{Extra arguments. It is not required.}
}
\value{
An object of the power analysis. The power for all parameters in the model as well as the indirect effects if specified.
}
\description{
A power curve is useful to graphically display how power changes with sample size (e.g., \cite{Zhang & Wang}).
This function is to generate a power curve for SEM based on Monte Carlo simulation, either using Sobel test or bootstrap method to test the indirect / mediation effects if applicable.
}
\examples{
\donttest{
#To specify the model
ex2model ="
		ept ~ start(0.4)*hvltt + b*hvltt + start(0)*age + start(0)*edu + start(2)*R
		hvltt ~ start(-0.35)*age + a*age +c*edu + start(0.5)*edu
		R ~ start(-0.06)*age + start(0.2)*edu
		R =~ 1*ws + start(0.8)*ls + start(0.5)*lt
		age ~~ start(30)*age
		edu ~~ start(8)*edu
		age ~~ start(-2.8)*edu
		hvltt ~~ start(23)*hvltt
		R ~~ start(14)*R
		ws ~~ start(3)*ws
		ls ~~ start(3)*ls
		lt ~~ start(3)*lt
		ept ~~ start(3)*ept
	"
#To specify the indirect effects
indirect = "ind1 := a*b + c*b" 
nobs <- seq(100, 2000, by =200)
#To calculate power curve:
power.curve = wp.mc.sem.power.curve(model=ex2model, indirect=indirect,
                              nobs=nobs, type='boot', parallel="muticore")
}

}
\references{
Rosseel, Y. (2012). Lavaan: An R package for structural equation modeling and more. Version 0.5–12 (BETA). Ghent, Belgium: Ghent University.

Thoemmes, F., MacKinnon, D. P., & Reiser, M. R. (2010). Power analysis for complex mediational designs using Monte Carlo methods. Structural Equation Modeling, 17(3), 510-534.

Zhang, Z., & Yuan, K.-H. (2018). Practical Statistical Power Analysis Using Webpower and R (Eds). Granger, IN: ISDSA Press.
}
