% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calc_lin_lnl_quad_fast}
\alias{calc_lin_lnl_quad_fast}
\title{This function calcuates the liklihood of the model using integration by adaptive quadrature}
\usage{
calc_lin_lnl_quad_fast(y, yhat, level, Z, Qi, omega, W, C, qp, omegaFull,
  QiFull, ZFull, top = TRUE, atPoint = FALSE,
  integralMultiplierExponent = 0L, integralZColumn = 1L, verbose = TRUE,
  acc = 120L)
}
\arguments{
\item{y}{a numeric vector, the response.}

\item{yhat}{the current predicted values of the response}

\item{level}{an integer that respresents the number of levels in the likelihood
that is desired. In a two level model this function will be called
with l=2 and it will recurse and call itself with l=1}

\item{Z}{a list of the Z matricies where the index of Z indicates the level.
of the Z matri. Z[[1]] is NULL because there is no individual lavel Zs.}

\item{Qi}{the scaling factor for the adaptive quadratures (per group)}

\item{omega}{a list of the b estimates for ech group}

\item{W}{list of weight matricies. must have `w` and `index` columns}

\item{C}{a list of Cholesky decompositions of the Sigma matricies.
C[[1]] is simply the residual variance (a scalar) while C[[l]] for 
l > 1 is a matrix with the name number of rows and columns as the 
Z matrix for that level.}

\item{qp}{Gaussian quadrature result from statmod::gauss.quad.}

\item{omegaFull}{numeric, the b estimates for each group duplicated so each element has one row per observation (like Zfull)}

\item{QiFull}{the scaling factors for adaptive quarature points duplicated so each element has one row per observation (like Zfull)}

\item{ZFull}{Z expended such that each Z[[i]] matrix contains  one row for each observation (ie each element has same number of rows as original data)}

\item{top}{boolean set to TRUE to return a single scalar, otherwise returns a vector}

\item{atPoint}{boolean, indicates likelihood should be calculated at single point
at the top level and then integrated below that. This is useful
for finding the maximum posterior (or likelihood) extimate for 
the random effects}

\item{integralMultiplierExponent}{a single integer, the function evaluates the
integral times the randome effect to this power
when set to 0, it is just the log-likelhood
when set to 1, this can be used to estimate the
expected value.}

\item{integralZColumn}{is the column index of Z to use integralMultiplierExponent on
only one random effect at a time can be integrated over, and the integration happens at the top level.}

\item{verbose}{boolean set to TRUE to get verbose output}

\item{acc}{numeric, accuracy of the mpfr}
}
\description{
calculates the log-likelihood of an l level mixed model using adaptive quadrature.
the genral model is y = Xb + ZU + e
but that values of beta and U are not included in the call. Instead this information
is contained in yhat which incorporates Xb at the top level and all relevant 
Zu information at lower levels.
}
\author{
Huade Huo, Paul Bailey, Claire Kelley
}
