% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROC.R
\name{ROCPlot}
\alias{ROCPlot}
\title{Plot receiver operating characteristic plot.}
\usage{
ROCPlot(frame, xvar, truthVar, truthTarget, title, ..., returnScores = FALSE,
  nrep = 100, parallelCluster = NULL)
}
\arguments{
\item{frame}{data frame to get values from}

\item{xvar}{name of the independent (input or model) column in frame}

\item{truthVar}{name of the dependent (output or result to be modeled) column in frame}

\item{truthTarget}{value we consider to be positive}

\item{title}{title to place on plot}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{returnScores}{logical if TRUE return detailed permutedScores}

\item{nrep}{number of permutation repititions to estimate p values.}

\item{parallelCluster}{(optional) a cluster object created by package parallel or package snow.}
}
\description{
Plot receiver operating characteristic plot.
}
\examples{

set.seed(34903490)
x = rnorm(50)
y = 0.5*x^2 + 2*x + rnorm(length(x))
frm = data.frame(x=x,yC=y>=as.numeric(quantile(y,probs=0.8)))
WVPlots::ROCPlot(frm, "x", "yC", TRUE, title="Example ROC plot")

}
