% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walsGLM.R
\name{walsGLMfitIterate}
\alias{walsGLMfitIterate}
\title{Iteratively fitting walsGLM, internal function for walsGLM.formula and
walsGLM.matrix.}
\usage{
walsGLMfitIterate(
  y,
  X1,
  X2,
  family,
  na.action = NULL,
  weights = NULL,
  offset = NULL,
  prior = weibull(),
  controlGLMfit = list(),
  keepY = TRUE,
  keepX = FALSE,
  iterate = FALSE,
  tol = 1e-06,
  maxIt = 50,
  nIt = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{y}{Response as vector.}

\item{X1}{Design matrix for focus regressors. Usually includes a constant
(column full of 1s) and can be generated using model.matrix().}

\item{X2}{Design matrix for auxiliary regressors. Usually does not include
a constant column and can also be generated using model.matrix().}

\item{family}{Object of class \code{"\link[WALS]{familyWALS}"}.}

\item{na.action}{Not implemented yet.}

\item{weights}{Not implemented yet.}

\item{offset}{Not implemented yet.}

\item{prior}{Object of class \code{"\link[WALS]{familyPrior}"}. For example
\code{\link[WALS]{weibull}} or \code{\link[WALS]{laplace}}.}

\item{controlGLMfit}{Controls estimation of starting values for one-step ML,
passed to \code{\link[stats]{glm.fit}}. See also \code{\link[stats]{glm.control}}.}

\item{keepY}{If \code{TRUE}, then output keeps response.}

\item{keepX}{If \code{TRUE}, then output keeps the design matrices.}

\item{iterate}{if \code{TRUE} then the WALS algorithm is iterated using the previous
estimates as starting values.}

\item{tol}{Only used if \code{iterate = TRUE} and \code{nIt = NULL}.
If the Euclidean distance between the previous and current coefficient vector
divided by the square root of the length of the vector falls below tol, then
the algorithm stops. See below for more details.}

\item{maxIt}{Only used if \code{iterate = TRUE} and \code{nIt = NULL}. Aborts
iterative fitting when number of iterations exceed maxIt.}

\item{nIt}{Only used if \code{iterate = TRUE}. If this is specified, then tol
is ignored and the algorithm iterates \code{nIt} times.}

\item{verbose}{If \code{verbose = TRUE}, then it prints the iteration process
(only relevant if \code{iterate = TRUE}).}

\item{...}{Arguments to be passed to the workhorse function walsGLMfit.}
}
\value{
A list containing all elements returned from \code{\link[WALS]{walsGLMfit}}
and additionally the following elements:
\item{y}{If \code{keepY = TRUE}, contains the response vector.}
\item{x}{list. If \code{keepX} is true, then it is a list with elements
\code{x1} and \code{x2} containing the design matrices of the focus and
auxiliary regressors, respectively.}
\item{initialFit}{List containing information (e.g. convergence) on the
estimation of the starting values for \code{\link[WALS]{walsGLMfit}}.
See \code{\link[stats]{glm.fit}} for more information.}
\item{weights}{returns the argument \code{weights}.}
\item{offset}{returns the argument \code{offset}.}
\item{converged}{Logical. Only relevant if \code{iterate = TRUE}. Equals
\code{TRUE} if iterative fitting converged, else \code{FALSE}. Is \code{NULL}
if \code{iterate = FALSE}.}
\item{it}{Number of iterations run in the iterative fitting algorithm.
\code{NULL} if \code{iterate = FALSE}.}
\item{deviance}{Deviance of the fitted regression model.}
\item{residuals}{Raw residuals, i.e. response - fitted mean.}
}
\description{
Wrapper around \code{\link[WALS]{walsGLMfit}} that allows iteratively
(re-)fitting \code{\link[WALS]{walsGLM}} models.
}
\details{
The parameter \code{tol} is used to control the convergence of the iterative
fitting algorithm. Let \eqn{i} be the current iteration step for the
coefficient vector \eqn{\beta_{i} = (\beta_{i,1}, \ldots, \beta_{i,k})', k > 0}.
If
\deqn{\frac{||\beta_{i} - \beta_{i-1}||_{2}}{\sqrt{k}}
= \sqrt{\frac{\sum_{j = 1}^{k} (\beta_{i,j} - \beta_{i-1,j})^{2}}{k}} < \texttt{tol},}
then the fitting process is assumed to have converged and stops.
}
\examples{
data("HMDA", package = "AER")
X <- model.matrix(deny ~ pirat + hirat + lvrat + chist + mhist + phist + selfemp + afam,
                  data = HMDA)
X1 <- X[,c("(Intercept)", "pirat", "hirat", "lvrat", "chist2", "chist3",
        "chist4", "chist5", "chist6", "mhist2", "mhist3", "mhist4", "phistyes")]
X2 <- X[,c("selfempyes", "afamyes")]
y <- HMDA$deny

str(walsGLMfitIterate(y, X1, X2, family = binomialWALS(), prior = weibull(),
                      iterate = TRUE))

}
\seealso{
\link{walsGLM}, \link{walsGLMfit}.
}
