% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miniTools.R
\name{stock_id}
\alias{stock_id}
\title{Stock ID}
\usage{
stock_id(data_matrix, metadata, metadata_type)
}
\arguments{
\item{data_matrix}{a \code{data.frame} containing the data_matrix}

\item{metadata}{a \code{data.frame} containing samplemetadata or
variablemetadata}

\item{metadata_type}{"sample" or "variable" depending on metadata content}
}
\value{
a names \code{list} with three elements:
\itemize{
\item id.match a \code{data.frame} that contains original order of ids, names ;
\item dataMatrix the modified data matrix with names sanitized
\item Metadata the modified metadata matrix with names sanitized
This object can be used in reproduce_id() to replace sanitized names in data
matrix by original ones, in the right order.
}
}
\description{
stock_id
Functions to stock identifiers before applying make.names() and
to reinject it into final matrices.
stock_id stocks original identifiers and original order
needs checked data regarding table match.
}
\examples{
\donttest{

myDM <- data.frame(data = 1:6, a = 2:7, b = 3:8, c = 2:7, d = 3:8, e = 2:7)
myvM <- data.frame(variable = 1:6, x = 4:9, y = 2:7, z = 3:8)

A <- W4MRUtils::stock_id(myDM, myvM, "variable")
myDM <- A$dataMatrix
myvM <- A$Metadata
A <- A$id.match

## processing that may change order or requires specific identifiers format
## ...
datamatrix <- as.data.frame(myDM)
sample_metadata <- as.data.frame(myvM)

B <- W4MRUtils::reproduce_id(datamatrix, sample_metadata, "variable", A)
datamatrix <- B$dataMatrix
sample_metadata <- B$Metadata
}

}
\author{
M.Petera
}
