% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_simon.R
\name{r_simon}
\alias{r_simon}
\title{Random Generator based on Simon's Two-Stage Design}
\usage{
r_simon(R, n1, n, r1, prob)
}
\arguments{
\item{R}{positive \link[base]{integer} scalar, number of trials \eqn{R}}

\item{n1, n}{positive \link[base]{integer} scalars, Stage-1 sample size \eqn{n_1} and total sample size \eqn{n}}

\item{r1}{non-negative \link[base]{integer} scalar, number of response
in Stage-1 \eqn{r_1} required \emph{exclusively},
i.e., passing Stage-1 indicates observing \eqn{>r_1} responses}

\item{prob}{\link[base]{double} scalar, true response rate \eqn{p}}
}
\value{
Function \link{r_simon} returns an \link[base]{integer} \link[base]{vector} of length \eqn{R},
which are the \eqn{R} copies of the number of responses in the Simon's two-stage design.
}
\description{
Random generator based on Simon's two-stage design.
}
\details{
Function \link{r_simon} generates \eqn{R} copies of the number of responses \eqn{y} in the Simon's two-stage design.
The conclusion of the trials are,
\describe{
\item{\eqn{y \leq r_1}}{indicates early termination}
\item{\eqn{r_1 < y \leq r}}{indicates failure to reject \eqn{H_0}}
\item{\eqn{y > r}}{indicates success to reject \eqn{H_0}}
}

Here \eqn{r} is not needed to \emph{generate} the random number of responses \eqn{y}.
Instead, \eqn{r} is needed to \emph{determine} if the trial is a failure or a success.
Therefore, \eqn{r} is not a parameter in \link{r_simon}.
}
\examples{
library(clinfun)
ph2simon(pu = .2, pa = .4, ep1 = .05, ep2 = .1) # using 'Optimal'
# set.seed if needed 
(ys = r_simon(R = 10L, n1 = 19L, n = 54L, r1 = 4L, prob = .3))
table(cut.default(ys, breaks = c(0, 4L, 15L, 54L), right = TRUE,
  labels = c('early-termination', 'fail', 'success')))

}
