% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VhgAddPhylum.R
\name{VhgAddPhylum}
\alias{VhgAddPhylum}
\title{VhgAddPhylum: extract Phylum information}
\usage{
VhgAddPhylum(file, groupby = "best_query")
}
\arguments{
\item{file}{A data frame containing VirusHunter or VirusGatherer hittable results.}

\item{groupby}{(optional): A character specifying the column containing the groups (default: "best_query").
Note: Gatherer hittables do not have a "best_query" column. Please provide an appropriate column for grouping.}
}
\value{
Hittable with Phylum column
}
\description{
VhgAddPhylum adds a \code{Phylum} column to the provided VirusHunter or VirusGatherer hittable,
with each entry in the column reflecting the phylum name derived from the \code{groupby} column for each observation.
}
\examples{

path <- system.file("extdata", "virushunter.tsv", package = "Virusparies")
vh_file <- ImportVirusTable(path)

vh_file_filtered <- VhgPreprocessTaxa(vh_file,"Family")

processed_taxa <- VhgAddPhylum(vh_file_filtered,"ViralRefSeq_taxonomy")

print(unique(processed_taxa$Phylum))

}
\seealso{
VirusHunterGatherer is available here: \url{https://github.com/lauberlab/VirusHunterGatherer}.
}
\author{
Sergej Ruff
}
