% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vca.R
\name{reScale}
\alias{reScale}
\title{Re-Scale results of 'VCA' or 'VCAinference'}
\usage{
reScale(obj, VarVC = TRUE)
}
\arguments{
\item{obj}{(object) either of class 'VCA' or 'VCAinference'}

\item{VarVC}{(logical) TRUE = variance-covariance matrix of the fitted model 'obj'
will be computed and automatically re-scaled, FALSE = variance-covariance
matrix will not be computed and re-scaled. This might cause wrong results
in downstream analyses which require this matrix on the correct scale! Only
use this option if computation time really matters!}
}
\value{
(object) either of class 'VCA' or 'VCAinference', where results have been 
transformed back to the original scale of the response variable
}
\description{
Function adjusts variance components (VC) and standard deviations (SD) and their respective
confidence intervals of 'VCAinference' objects, and the 'VCAobj' sub-element. For 'VCA' objects
the VC and SD values are adjusted as well as the fixed and random effects and the covariance-matrix
of fixed effects.
}
\examples{
\dontrun{
data(dataEP05A2_3)

# reference values
fit0 <- anovaVCA(y~day/run, dataEP05A2_3, MME=TRUE)
inf0 <- VCAinference(fit0, VarVC=TRUE)

fit1 <- Scale("anovaVCA", y~day/run, dataEP05A2_3, MME=TRUE)
inf1 <- VCAinference(fit1, VarVC=TRUE)
inf1 <- reScale(inf1)

# compare to reference
print(inf0, what="VC")
print(inf1, what="VC")
print(inf0, what="SD")
print(inf1, what="SD")
print(inf0, what="CV")
print(inf1, what="CV")

# now use REML-based estimation
fit0 <- remlVCA(y~day/run, dataEP05A2_3)
inf0 <- VCAinference(fit0)

fit1 <- Scale("remlVCA", y~day/run, dataEP05A2_3, MME=TRUE)
inf1 <- VCAinference(fit1)
inf1 <- reScale(inf1)

# compare to reference
print(inf0, what="VC")
print(inf1, what="VC")
print(inf0, what="SD")
print(inf1, what="SD")
print(inf0, what="CV")
print(inf1, what="CV")
}
}
\seealso{
\code{\link{Scale}}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
