% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trvsvisit.R
\name{trvseleinq}
\alias{trvseleinq}
\title{Using character element to visit the traversal table}
\usage{
trvseleinq(trvs, inq)
}
\arguments{
\item{trvs}{The traversal table to be visited, which should be generated from the vector binary tree by the function trvs().}

\item{inq}{A desired character element to match the traversal table.}
}
\value{
Return an inquiry result with a numeric item index, a character pattern and its coordinate in form of integer vector.
}
\description{
Visit the traversal table generated from a vector binary tree through the character element determined by the argument \code{inq}, and return
an inquiry result containing its numeric item index, the character pattern and its corresponding coordinate.
}
\examples{
#Make traversal table:
trav <- trvs(dl2vbt(chrvec2dl(colnames(datatest))))

#Visit specific element by character pattern:
trvseleinq(trav,"Strain-1100-0.001-0.6")
}
\keyword{Trav.Inq}
\keyword{Trav.Table}
