% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SUMMARY.R
\name{summary.UPG.Binomial}
\alias{summary.UPG.Binomial}
\title{Estimation results and tables for UPG.Binomial objects}
\usage{
\method{summary}{UPG.Binomial}(
  object = NULL,
  ...,
  q = c(0.025, 0.975),
  names = NULL,
  digits = 2,
  include = NULL,
  table = NULL,
  cap = NULL
)
}
\arguments{
\item{object}{an object of class \code{UPG.Binomial}.}

\item{...}{other summary parameters.}

\item{q}{a numerical vector of length two providing the posterior quantiles to be extracted. Default are 0.025 and 0.975 quantiles.}

\item{names}{a character vector indicating names for the variables used in the output.}

\item{digits}{number of digits to be included in output. Last digit will be rounded using \code{round}.}

\item{include}{can be used to summarize and tabulate only a subset of variables. Specify the columns of X that should be kept in the plot. See examples for further information.}

\item{table}{can be used to return a LaTeX table (\code{'latex'}), a Word table (\code{'pandoc'}) and HTML tables (\code{'html'}) via \code{knitr}. Include package "booktabs" in LaTeX preamble for LaTeX tables.}

\item{cap}{character vector that can be used to specify the table caption.}
}
\value{
Returns a \code{knitr_kable} object containing the summary table.
}
\description{
\code{summary} generates a summary of estimation results for \code{UPG.Binomial} objects. Point estimates, estimated standard deviation as well as credible intervals for each variable are tabulated. In addition, an indicator quickly shows whether the credible interval includes zero or not. Moreover, LaTeX, HTML and pandoc tables can be quickly generated via \code{knitr}.
}
\examples{
\donttest{
# estimate a binomial logit model using example data
library(UPG)
data(titanic)
y  = titanic[,1]
Ni = titanic[,2]
X  = titanic[,-c(1,2)]
results.binomial = UPG(y = y, X = X, Ni = Ni, model = "binomial")

# basic summary of regression results
summary(results.binomial)

# generate a LaTeX table with subset of variables and custom names
summary(results.binomial,
        include=c(1,3),
        names=c("V. kept 1", "V. kept 3"),
        table="latex")
}
}
\seealso{
\code{\link{plot.UPG.Binomial}} to plot a \code{UPG.Binomial} object.
\code{\link{predict.UPG.Binomial}} to predict probabilities using a \code{UPG.Binomial} object.
\code{\link{coef.UPG.Binomial}} to extract coefficients from a \code{UPG.Binomial} object.
}
\author{
Gregor Zens
}
