% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PTSfunctions.R
\name{PTSsetup}
\alias{PTSsetup}
\title{PTSsetup}
\usage{
PTSsetup(
  y,
  u = NULL,
  model = "???",
  s = frequency(y),
  h = 2 * s,
  criterion = "aic",
  lambda = 1,
  armaIdent = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{y}{a time series to forecast (it may be either a numerical vector or
a time series object). This is the only input required. If a vector, the additional
input \code{s} should be supplied compulsorily (see below).}

\item{u}{a matrix of input time series. If
the output wanted to be forecast, matrix \code{u} should contain future values for inputs.}

\item{model}{the model to estimate. It is a single string indicating the type of
model for each component with one or two letters:
\itemize{
\item Error: ? / N / A

\item Trend: ? / N / A / Ad / L

\item Seasonal: ? / N / A / D (trigonometric with different variances)

}}

\item{s}{seasonal period of time series (1 for annual, 4 for quarterly, ...)}

\item{h}{forecast horizon. If the model includes inputs h is not used, the lenght of u is used instead.}

\item{criterion}{information criterion for identification ("aic", "bic" or "aicc").}

\item{lambda}{Box-Cox lambda parameter (NULL: estimate)}

\item{armaIdent}{check for arma models for error component (TRUE / FALSE).}

\item{verbose}{intermediate estimation output (TRUE / FALSE)}
}
\value{
An object of class \code{PTS}. It is a list with fields including all the inputs and
        the fields listed below as outputs. All the functions in this package fill in
        part of the fields of any \code{PTS} object as specified in what follows (function
        \code{PTS} fills in all of them at once):

After running \code{PTSmodel} or \code{PTSestim}:
\itemize{
\item p0:       Initial values for parameter search
\item p:        Estimated parameters
\item lambda:   Estimated Box-Cox lambda parameter
\item v:        Estimated innovations (white noise in correctly specified models)
\item yFor:     Forecasted values of output
\item yForV:    Variance of forecasted values of output
}

After running \code{PTSvalidate}:
\itemize{
\item table: Estimation and validation table
}

After running \code{PTScomponents}:
\itemize{
\item comp:  Estimated components in matrix form
}

Standard methods applicable to PTS objects are print, summary, plot,
fitted, residuals, logLik, AIC, BIC, coef, predict, tsdiag.
}
\description{
Run up PTS general univariate MSOE models
}
\details{
See help of \code{PTS}.
}
\examples{
\dontrun{
m1 <- PTSsetup(log(AirPassengers))
}
}
\seealso{
\code{\link{PTS}}, \code{\link{PTSmodel}}, \code{\link{PTSvalidate}},
         \code{\link{PTScomponents}}, \code{\link{PTSestim}}
}
\author{
Diego J. Pedregal
}
