% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_pancan_value.R
\name{vis_gene_cor_cancer}
\alias{vis_gene_cor_cancer}
\title{Visualize Gene-Gene Correlation in a TCGA Cancer Type}
\usage{
vis_gene_cor_cancer(
  Gene1 = "CSF1R",
  Gene2 = "JAK3",
  data_type1 = "mRNA",
  data_type2 = "mRNA",
  purity_adj = TRUE,
  cancer_choose = "GBM",
  use_regline = TRUE,
  cor_method = "spearman",
  use_all = FALSE,
  alpha = 0.5,
  color = "#000000",
  opt_pancan = .opt_pancan
)
}
\arguments{
\item{Gene1}{a molecular identifier (e.g., "TP53") or a formula specifying
genomic signature (\code{"TP53 + 2 * KRAS - 1.3 * PTEN"}).}

\item{Gene2}{a molecular identifier (e.g., "TP53") or a formula specifying
genomic signature (\code{"TP53 + 2 * KRAS - 1.3 * PTEN"}).}

\item{data_type1}{choose gene profile type for the first gene, including "mRNA","transcript","methylation","miRNA","protein","cnv_gistic2"}

\item{data_type2}{choose gene profile type for the second gene, including "mRNA","transcript","methylation","miRNA","protein","cnv_gistic2"}

\item{purity_adj}{whether performing partial correlation adjusted by purity}

\item{cancer_choose}{TCGA cohort name, e.g. "ACC".}

\item{use_regline}{if \code{TRUE}, add regression line.}

\item{cor_method}{correlation method.}

\item{use_all}{use all sample, default \code{FALSE}.}

\item{alpha}{dot alpha.}

\item{color}{dot color.}

\item{opt_pancan}{specify one dataset for some molercular profiles}
}
\description{
Visualize Gene-Gene Correlation in a TCGA Cancer Type
}
