#' Print updates to console
#'
#' @param message_number the index of the message to print
#' @param file the name of the file being processed
#' @param vm_variables variables being used to calculate vector magnitude
#' @param duration the duration of processing
#' @param is_Message print update as a message?
#'
#' @keywords internal
message_update <-
  function(message_number,
    file,
    vm_variables,
    duration,
    cvs,
    window_secs,
    is_message = FALSE,
    n) {

  note <-
    switch(
      message_number,
      paste("\nProcessing", basename(file), "..."),
      paste(
        "\n     Getting VM for variables searched on the following criteri(a/on):",
        vm_variables,
        "\n"
      ),
      "Failed to detect start time in file header",
      paste("\nFile processed. Processing took", round(duration/60, 2), "minutes.\n"),
      "\n\n-- Filtering Gyroscope...",
      " Done.\n",
      "\n-- Calculating Vector Magnitudes...",
      "\n     Vector magnitude calculation complete.\n",
      "Number of rows not divisible by samp_rate*output_window\nTruncating data.",
      "\n-- Collapsing data. This could take awhile...",
      paste("\nCalculating CV per 10s for:", paste(cvs, collapse = " and ")),
      "\nThis could take awhile. Be patient...",
      paste("\n... Getting ", window_secs, "s CVs", sep = ""),
      "\n\n",
      "All two-regression processing complete.",
      paste(
        "\nTwo-Regression processing complete. Total processing time:",
        round(duration / 60, 2),
        "minutes.\n"
      ),
      "No IMU file detected, yet Algorithm is not set to 1. Setting to 1.",
      "Error in file formatting. Returning NULL.",
      "Length of X and Y differ. Returning NULL.",
      paste("Determining direction from mean values of x and y, replicating", n, "times."),
      "Unable to detect sampling rate. Defaulting to 100",
      "IMU file provided, but Algorithm 1 selected. Ignoring IMU file. Set IMU_ignore_A1 = FALSE to override.",
      "Only algorithms 1-3 exist. Removing selections outside that range.",
      "No valid algorithms specified. Setting Algorithm to 1.",
      "Wear_Location must be one or more of c(\"Hip\", \"Left Wrist\", \"Right Wrist\", \"Left Ankle\", \"Right Ankle\").",
      "No valid Wear_Location specified. Defaulting to Hip.",
      "Primary accelerometer file is formatted unexpectedly. Processing with read.csv() -- be prepared to wait.",
      "28"
    )
  if (is_message) {
    message(note)
  } else{
    cat(note)
  }
}
