% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/letterValue.R
\name{letterValue}
\alias{letterValue}
\title{Letter-Value Estimation of Tukey \eqn{g}-&-\eqn{h} Distribution}
\usage{
letterValue(
  x,
  g_ = seq.int(from = 0.15, to = 0.25, by = 0.005),
  h_ = seq.int(from = 0.15, to = 0.35, by = 0.005),
  halfSpread = c("both", "lower", "upper"),
  ...
)
}
\arguments{
\item{x}{\link[base]{double} \link[base]{vector}, one-dimensional observations}

\item{g_}{\link[base]{double} \link[base]{vector}, probabilities used for estimating \eqn{g} parameter.
Or, use \code{g_ = FALSE} to implement the constraint \eqn{g=0}
(i.e., an \eqn{h}-distribution is estimated).}

\item{h_}{\link[base]{double} \link[base]{vector}, probabilities used for estimating \eqn{h} parameter.
Or, use \code{h_ = FALSE} to implement the constraint \eqn{h=0}
(i.e., a \eqn{g}-distribution is estimated).}

\item{halfSpread}{\link[base]{character} scalar,
either to use \code{'both'} for half-spreads (default),
\code{'lower'} for half-spread, or \code{'upper'} for half-spread.}

\item{...}{additional parameters, currently not in use}
}
\value{
Function \link{letterValue} returns a \code{'letterValue'} object,
which is \link[base]{double} \link[base]{vector} of estimates \eqn{(\hat{A}, \hat{B}, \hat{g}, \hat{h})}
for a Tukey \eqn{g}-&-\eqn{h} distribution.
}
\description{
Letter-value based estimation (Hoaglin, 1985) of
Tukey \eqn{g}-, \eqn{h}- and \eqn{g}-&-\eqn{h} distribution.
All equation numbers mentioned below refer to Hoaglin (1985).
}
\details{
Unexported function \code{letterV_g()} estimates parameter \eqn{g} using equation (10) for \eqn{g}-distribution
and the equivalent equation (31) for \eqn{g}-&-\eqn{h} distribution.

Unexported function \code{letterV_B()} estimates parameter \eqn{B} for Tukey \eqn{g}-distribution
(i.e., \eqn{g\neq 0}, \eqn{h=0}), using equation (8a) and (8b).

Unexported function \code{letterV_Bh_g()} estimates parameters \eqn{B} and \eqn{h} when \eqn{g\neq 0}, using equation (33).

Unexported function \code{letterV_Bh()} estimates parameters \eqn{B} and \eqn{h} for Tukey \eqn{h}-distribution,
i.e., when \eqn{g=0} and \eqn{h\neq 0}, using equation (26a), (26b) and (27).

Function \link{letterValue} plays a similar role as \code{fitdistrplus:::start.arg.default},
thus extends \code{fitdistrplus::fitdist} for estimating Tukey \eqn{g}-&-\eqn{h} distributions.
}
\note{
Parameter \code{g_} and \code{h_} does not have to be truly unique; i.e., \link[base]{all.equal} elements are allowed.
}
\examples{
set.seed(77652); x = rGH(n = 1e3L, g = -.3, h = .1)
letterValue(x, g_ = FALSE, h_ = FALSE)
letterValue(x, g_ = FALSE)
letterValue(x, h_ = FALSE)
(m3 = letterValue(x))

library(fitdistrplus)
fit = fitdist(x, distr = 'GH', start = as.list.default(m3))
plot(fit) # fitdistrplus:::plot.fitdist

}
\references{
Hoaglin, D.C. (1985). Summarizing Shape Numerically: The \eqn{g}-and-\eqn{h} Distributions.
\doi{10.1002/9781118150702.ch11}
}
