% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.lfq.R
\name{plot.lfq}
\alias{plot.lfq}
\title{Plotting of length frequency data (with VBGF curves)}
\usage{
\method{plot}{lfq}(x, Fname = "rcounts", par = NULL, agemax = NULL,
  flagging.out = TRUE, col = "blue", add.image = TRUE, col.image = NULL,
  zlim = NULL, zlimtype = "balanced", date.axis = "traditional",
  date.at = seq(as.Date("1500-01-01"), as.Date("2500-01-01"), by = "months"),
  date.format = "'\%y-\%b", xlab = "", ylab = "Length classes",
  draw = TRUE, ...)
}
\arguments{
\item{x}{a list of the class "lfq" consisting of following parameters:
\itemize{
  \item \strong{midLengths} midpoints of the length classes,
  \item \strong{dates} dates of sampling times (class Date),
  \item \strong{catch} matrix with catches/counts per length class (row) and sampling date (column);
}}

\item{Fname}{indicating whether restructured ("rcounts") or original frequencies ("catch") should be
displayed (default: "rcounts")}

\item{par}{a list with following growth parameters (default NULL):
 \itemize{
  \item \strong{Linf} length infinity,
  \item \strong{K} curving coefficient,
  \item \strong{C} amplitude of growth oscillation (optional),
  \item \strong{WP} winter point (WP = ts + 0.5) (optional);
}}

\item{agemax}{maximum age of species; default NULL, then estimated from Linf}

\item{flagging.out}{logical; should positive peaks be flagged out?
(Default : TRUE)}

\item{col}{colour of growth curves (default: 1)}

\item{add.image}{logical; should and image be added to the lfq plot
(default : TRUE)}

\item{col.image}{colour of image, by default (NULL) red and blue colours
are used}

\item{zlim}{the minimum and maximum z values for which colors should be
plotted (default : NULL).}

\item{zlimtype}{indicating if zlim should be based on the range of
the catch ("range") or based on the maximum catch ("balanced", default). This parameter is only
considered if zlim is NULL.}

\item{date.axis}{the style of the x axis. By default the "traditional"
approach is used with years under the months. Alternatively, by using
"modern" the date is plotted in one line according to the chosen
 format \code{date.format}.}

\item{date.at}{the points at which tick-marks are to be drawn. Non-finite
(infinite, NaN or NA) values are omitted. By default it is
seq(as.Date("1500-01-01"), as.Date("2500-01-01"), by="months")}

\item{date.format}{format of date  (default : "\%y-\%b")}

\item{xlab}{label of x axis (default : "")}

\item{ylab}{label of y axis (default : "Length classes")}

\item{draw}{logical; indicating whether growth curves should be added to
lfq plot if parameters are provided (default : TRUE)}

\item{...}{additional options of the plot function}
}
\description{
This function plots length frequency (lfq) samples sequentially
 arranged in time. An object
 of "lfq" class is obatined by applying the \code{\link{lfqRestructure}}
 function. In case growth
 parameters are known, von Bertalanffy growth curves can be plotted through the lfq samples.
}
\details{
This function uses \code{\link{lfqFitCurves}} when growth
   parameters are provided to plot growth curves, this can be turned off with
   \code{draw} = FALSE.
}
\examples{
data(synLFQ4)
res <- lfqRestructure(synLFQ4)
plot(x = res, Fname = "rcounts")
plot(res, Fname = "rcounts", par = list(Linf = 80, K = 0.5, t_anchor = 0.25))
plot(res, Fname = "catch", par = list(Linf = 80, K = 0.5,
   t_anchor = 0.25, C= 0.75, WP = -0.5))

# plot length frequency data without restructuring
class(synLFQ4) <- "lfq"
plot(synLFQ4, Fname = "catch")

}
\references{
Brey, T., Soriano, M., and Pauly, D. 1988. Electronic length frequency analysis: a revised and expanded
user's guide to ELEFAN 0, 1 and 2.

Pauly, D. 1981. The relationship between gill surface area and growth performance in fish:
a generalization of von Bertalanffy's theory of growth. \emph{Meeresforschung}. 28:205-211

Pauly, D. and N. David, 1981. ELEFAN I, a BASIC program for the objective extraction of
growth parameters from length-frequency data. \emph{Meeresforschung}, 28(4):205-211

Pauly, D., 1985. On improving operation and use of ELEFAN programs. Part I: Avoiding
"drift" of K towards low values. \emph{ICLARM Conf. Proc.}, 13-14

Pauly, D., 1987. A review of the ELEFAN system for analysis of length-frequency data in
fish and aquatic invertebrates. \emph{ICLARM Conf. Proc.}, (13):7-34

Pauly, D. and G. R. Morgan (Eds.), 1987. Length-based methods in fisheries research.
(No. 13). WorldFish

Pauly, D. and G. Gaschuetz. 1979. A simple method for fitting oscillating length growth data, with a
program for pocket calculators. I.C.E.S. CM 1979/6:24. Demersal Fish Comittee, 26 p.

Pauly, D. 1984. Fish population dynamics in tropical waters: a manual for use with programmable
calculators (Vol. 8). WorldFish.

Quenouille, M. H., 1956. Notes on bias in estimation. \emph{Biometrika}, 43:353-360

Somers, I. F., 1988. On a seasonally oscillating growth function. ICLARM Fishbyte 6(1): 8-11.

Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. \emph{FAO Fisheries Technical Paper}, (306.1, Rev. 2): 407 p.

Tukey, J., 1958. Bias and confidence in not quite large samples.
\emph{Annals of Mathematical Statistics}, 29: 614

Tukey, J., 1986. The future of processes of data analysis. In L. V. Jones (Eds.),
The Collected Works of John W. Tukey philosophy and principles of data analysis:
1965-1986 (Vol. 4, pp. 517-549). Monterey, CA, USA: Wadsworth & Brooks/Cole
}

