% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.lfq.R
\name{plot.lfq}
\alias{plot.lfq}
\title{Plotting of length frequency data (with VBGF curves)}
\usage{
\method{plot}{lfq}(x, Fname = "rcounts", par = NULL,
  multiple_best_fits = 1, col = "blue", ...)
}
\arguments{
\item{x}{a list of the class "lfq" consisting of following parameters:
\itemize{
  \item \strong{midLengths} midpoints of the length classes,
  \item \strong{dates} dates of sampling times (class Date),
  \item \strong{catch} matrix with catches/counts per length class (row) and sampling date (column);
}}

\item{Fname}{indicating whether restructured ("rcounts") or original frequencies ("catch") should be
displayed (default: "rcounts")}

\item{par}{a list with following growth parameters (default NULL):
 \itemize{
  \item \strong{Linf} length infinity,
  \item \strong{K} curving coefficient,
  \item \strong{C} amplitude of growth oscillation (optional),
  \item \strong{WP} winter point (WP = ts + 0.5) (optional);
}}

\item{multiple_best_fits}{numeric; indicating which startingPoints should be used in case there are more
than one (default: 1)}

\item{col}{colour of growth curves (default: "blue")}

\item{...}{additional options of the plot function}
}
\description{
This function plots length frequency (lfq) samples sequentially arranged in time. An object
 of "lfq" class is obatined by applying the \code{\link{lfqRestructure}} function. In case growth
 parameters are known, von Bertalanffy growth curves can be plotted through the lfq samples.
}
\details{
This function runs \code{\link{lfqFitCurves}} when growth parameters are provided. Thereby the starting point
   calculated. It can happen that different starting points return the same fit (ESP value), with
   \code{multiple_best_fits} the preferred starting point can be chosen.
}
\examples{
data(trout)
res <- lfqRestructure(trout)
plot(x = res, Fname = "rcounts")
plot(res, Fname = "rcounts", par = list(Linf = 16, K = 0.77))
plot(res, Fname = "catch", par = list(Linf = 16, K = 0.77, C= 0.5, WP = 0.6))

# plot length frequency data without restructuring
class(trout) <- "lfq"
plot(trout, Fname = "catch")

}
\references{
Brey, T., Soriano, M., and Pauly, D. 1988. Electronic length frequency analysis: a revised and expanded
user's guide to ELEFAN 0, 1 and 2.

Pauly, D. 1981. The relationship between gill surface area and growth performance in fish:
a generalization of von Bertalanffy's theory of growth. \emph{Meeresforschung}. 28:205-211

Pauly, D. and N. David, 1981. ELEFAN I, a BASIC program for the objective extraction of
growth parameters from length-frequency data. \emph{Meeresforschung}, 28(4):205-211

Pauly, D., 1985. On improving operation and use of ELEFAN programs. Part I: Avoiding
"drift" of K towards low values. \emph{ICLARM Conf. Proc.}, 13-14

Pauly, D., 1987. A review of the ELEFAN system for analysis of length-frequency data in
fish and aquatic invertebrates. \emph{ICLARM Conf. Proc.}, (13):7-34

Pauly, D. and G. R. Morgan (Eds.), 1987. Length-based methods in fisheries research.
(No. 13). WorldFish

Pauly, D. and G. Gaschuetz. 1979. A simple method for fitting oscillating length growth data, with a
program for pocket calculators. I.C.E.S. CM 1979/6:24. Demersal Fish Comittee, 26 p.

Pauly, D. 1984. Fish population dynamics in tropical waters: a manual for use with programmable
calculators (Vol. 8). WorldFish.

Quenouille, M. H., 1956. Notes on bias in estimation. \emph{Biometrika}, 43:353-360

Somers, I. F., 1988. On a seasonally oscillating growth function. ICLARM Fishbyte 6(1): 8-11.

Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. \emph{FAO Fisheries Technical Paper}, (306.1, Rev. 2): 407 p.

Tukey, J., 1958. Bias and confidence in not quite large samples.
\emph{Annals of Mathematical Statistics}, 29: 614

Tukey, J., 1986. The future of processes of data analysis. In L. V. Jones (Eds.),
The Collected Works of John W. Tukey philosophy and principles of data analysis:
1965-1986 (Vol. 4, pp. 517-549). Monterey, CA, USA: Wadsworth & Brooks/Cole
}

