% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfqFitCurves.R
\name{lfqFitCurves}
\alias{lfqFitCurves}
\title{Fitting of VBGF curves through length frequency data (ELEFAN 1)}
\usage{
lfqFitCurves(lfq, par = list(Linf = 100, K = 0.1, C = 0, WP = 0))
}
\arguments{
\item{lfq}{a list of the class "lfq" consisting of following parameters:
\itemize{
  \item \strong{midLengths} midpoints of the length classes,
  \item \strong{dates} dates of sampling times (class Date),
  \item \strong{catch} matrix with catches/counts per length class (row) and sampling date (column);
}}

\item{par}{a list with following growth parameters:
 \itemize{
  \item \strong{Linf} length infinity in cm (default: 100),
  \item \strong{K} curving coefficient (default: 0.1),
  \item \strong{C} amplitude of growth oscillation (default: 0),
  \item \strong{WP} winter point (WP = ts + 0.5) (default: 0);
}}
}
\value{
A list with following list objects:
\itemize{
  \item \strong{max_ESP}: maximum explained sum of peaks,
  \item \strong{startingSample}: sample number which yield in best ESP value,
  \item \strong{startingLength}: length (in cm) which yield in best ESP value;
}
}
\description{
Second step of the Electronic LEngth Frequency ANalysis (ELEFAN), which fits von Bertalanffy
   growth curves through restructured length-frequency data.
}
\details{
This function is used in the analysis of growth parameters with the \code{\link{ELEFAN}} function. It is often
   referred to as ELEFAN 1. C expresses the amplitude of growth oscillations and
   should be between 0 (no oscillation) and 1 (oscillation with period of zero growth), values above 1 suggest
   a period of negative growth, and thus are unlikely. Winter point (WP) designates the period of the year when
   growth is slowest, which
   in the northern hemisphere is often found around 0.2 (February) and in the southern
   hemisphere aorund 0.7 (October) (Pauly and Morgan, 1987).
}
\examples{
data(trout)
res <- lfqRestructure(trout)
lfqFitCurves(res)

}
\references{
Brey, T., Soriano, M., and Pauly, D. 1988. Electronic length frequency analysis: a revised and expanded
user's guide to ELEFAN 0, 1 and 2.

Pauly, D. 1981. The relationship between gill surface area and growth performance in fish:
a generalization of von Bertalanffy's theory of growth. \emph{Meeresforsch}. 28:205-211

Pauly, D. and N. David, 1981. ELEFAN I, a BASIC program for the objective extraction of
growth parameters from length-frequency data. \emph{Meeresforschung}, 28(4):205-211

Pauly, D., 1985. On improving operation and use of ELEFAN programs. Part I: Avoiding
"drift" of K towards low values. \emph{ICLARM Conf. Proc.}, 13-14

Pauly, D., 1987. A review of the ELEFAN system for analysis of length-frequency data in
fish and aquatic invertebrates. \emph{ICLARM Conf. Proc.}, (13):7-34

Pauly, D. and G. R. Morgan (Eds.), 1987. Length-based methods in fisheries research.
(No. 13). WorldFish

Pauly, D. and G. Gaschuetz. 1979. A simple method for fitting oscillating length growth data, with a
program for pocket calculators. I.C.E.S. CM 1979/6:24. Demersal Fish Cttee, 26 p.

Pauly, D. 1984. Fish population dynamics in tropical waters: a manual for use with programmable
calculators (Vol. 8). WorldFish.

Quenouille, M. H., 1956. Notes on bias in estimation. \emph{Biometrika}, 43:353-360

Somers, I. F., 1988. On a seasonally oscillating growth function. ICLARM Fishbyte 6(1): 8-11.

Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. \emph{FAO Fisheries Technical Paper}, (306.1, Rev. 2): 407 p.

Tukey, J., 1958. Bias and confidence in not quite large samples.
\emph{Annals of Mathematical Statistics}, 29: 614

Tukey, J., 1986. The future of processes of data analysis. In L. V. Jones (Eds.),
The Collected Works of John W. Tukey-philosophy and principles of data analysis:
1965-1986 (Vol. 4, pp. 517-549). Monterey, CA, USA: Wadsworth & Brooks/Cole
}

