% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msltrend.R
\name{summary}
\alias{summary}
\title{Summary outputs of decomposed time series.}
\usage{
summary(object, wdir = " ", save_summary = "FALSE")
}
\arguments{
\item{object}{of class \dQuote{msl.trend} (see \code{\link{msl.trend}}) or
\dQuote{custom.trend} (see \code{\link{custom.trend}}).}

\item{wdir}{character string, providing the name of the directory to send
output files (e.g., \dQuote{C:/myproject/}) when the save_summary argument is set to "TRUE".
If this field is left blank the save_summary argument is switched off and a message
will be sent to the console.}

\item{save_summary}{logical, if \dQuote{TRUE} the printed summary of the
returned object is exported direct to the working directory and saved
as "summary_information.txt". Default = \dQuote{FALSE}.}
}
\description{
Summary outputs of decomposed time series.
}
\details{
This routine provides a screen summary of the respective outputs
from a \code{\link{msl.trend}} or \code{\link{custom.trend}} object. The
summary produced is identical to str( ) for an object of class
\dQuote{msl.trend} (see \code{\link{msl.trend}}) or \dQuote{custom.trend}
(see \code{\link{custom.trend}}).
}
\examples{

data(s) # msl.trend object
data(t) # custom.trend object
summary(s) # summary for object of class 'msl.trend'
summary(t) # summary for object of class 'custom.trend'

}
\seealso{
\code{\link{msl.trend}}, \code{\link{custom.trend}},
\code{\link{Balt}}, \code{\link{s}}, \code{\link{t}}.
}
