% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_write.R
\name{WriteTntCharacters}
\alias{WriteTntCharacters}
\alias{WriteTntCharacters.phyDat}
\alias{WriteTntCharacters.matrix}
\title{Write morphological character matrix to TNT file}
\usage{
WriteTntCharacters(
  dataset,
  filepath = NULL,
  comment = "Dataset written by `TreeTools::WriteTntCharacters()`",
  types = NULL,
  pre = "",
  post = ""
)

\method{WriteTntCharacters}{phyDat}(
  dataset,
  filepath = NULL,
  comment = "Dataset written by `TreeTools::WriteTntCharacters()`",
  types = NULL,
  pre = "",
  post = ""
)

\method{WriteTntCharacters}{matrix}(
  dataset,
  filepath = NULL,
  comment = "Dataset written by `TreeTools::WriteTntCharacters()`",
  types = NULL,
  pre = "",
  post = ""
)
}
\arguments{
\item{dataset}{Morphological dataset of class \code{phyDat} or \code{matrix}.}

\item{filepath}{Path to file; if \code{NULL}, returns a character vector.}

\item{comment}{Optional comment with which to entitle matrix.}

\item{types}{Optional list specifying where different data types begin.
\code{c(num = 1, dna = 10)} sets characters 1..9 as numeric, 10..end as DNA.}

\item{pre, post}{Character vector listing text to print before and after the
character matrix.  Specify \verb{pre = 'piwe=;} if the matrix is to be analysed
using extended implied weighting (\verb{xpiwe=}).}
}
\description{
Write morphological character matrix to TNT file
}
\examples{
data('Lobo', package = 'TreeTools')

WriteTntCharacters(Lobo.phy)

# Read with extended implied weighting
WriteTntCharacters(Lobo.phy, pre = 'piwe=10;', post = 'xpiwe=;')

# Write to a file with:
# WriteTntCharacters(Lobo.phy, 'example_file.tnt')
}
\seealso{
\code{\link[=ReadTntCharacters]{ReadTntCharacters()}}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
