% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{UnshiftTree}
\alias{UnshiftTree}
\title{Add tree to start of list}
\usage{
UnshiftTree(add, treeList)
}
\arguments{
\item{add}{Tree to add to the list, of class \code{\link[ape:read.tree]{phylo}}.}

\item{treeList}{A list of trees, of class \code{list},
\code{\link[ape:multiphylo]{multiPhylo}}, or, if a single tree,
\code{\link[ape:read.tree]{phylo}}.}
}
\value{
\code{UnshiftTree()} returns a list of class \code{list} or \code{multiPhylo}
(following the original class of \code{treeList}), whose first element is the
tree specified as `add.
}
\description{
\code{UnshiftTree()} adds a phylogenetic tree to the start of a list of trees.
This is useful where the class of a list of trees is unknown, or where
names of trees should be retained.
}
\details{
Caution: adding a tree to a \code{multiPhylo} object whose own attributes apply
to all trees, for example trees read from a Nexus file, causes data to be
lost.
}
\examples{
forest <- as.phylo(0:5, 6)
tree <- BalancedTree(6)

UnshiftTree(tree, forest)
UnshiftTree(tree, tree)
}
\seealso{
\code{\link[=c]{c()}} joins a tree or series of trees to a \code{multiPhylo} object, but loses
names and does not handle lists of trees.
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
