% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Splits.R
\name{TipsInSplits}
\alias{TipsInSplits}
\title{Tips contained within splits}
\usage{
TipsInSplits(splits)
}
\arguments{
\item{splits}{Object of class \code{Splits}.}
}
\value{
\code{TipsInSplits()} returns a named vector of integers, specifying the
number of tips contained within each split in \code{splits}.
}
\description{
\code{TipsInSplits()} specifies the number of tips that occur within each
bipartition split in a \code{Splits} object.
}
\examples{
tree <- PectinateTree(8)#'
splits <- as.Splits(tree)
TipsInSplits(splits)

plot(tree)
LabelSplits(tree, as.character(splits), frame = 'none', pos = 3L, cex = 0.7)
LabelSplits(tree, TipsInSplits(splits), unit = ' tips', frame = 'none',
            pos = 1L)

}
\seealso{
Other Splits operations: 
\code{\link{NSplits}()},
\code{\link{NTip}()},
\code{\link{SplitsInBinaryTree}()},
\code{\link{TipLabels}()},
\code{\link{as.Splits}()},
\code{\link{match}()}
}
\concept{Splits operations}
