% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Information.R
\name{UnrootedTreesMatchingSplit}
\alias{UnrootedTreesMatchingSplit}
\alias{LnUnrootedTreesMatchingSplit}
\alias{Log2UnrootedTreesMatchingSplit}
\title{Number of trees consistent with split}
\usage{
UnrootedTreesMatchingSplit(...)

LnUnrootedTreesMatchingSplit(...)

Log2UnrootedTreesMatchingSplit(...)
}
\arguments{
\item{\dots}{A series or vector of integers listing the number of tips in
each of a number of tree splits (e.g. bipartitions).
For example, \verb{3, 5} states that a character divides a set of eight tips into
a group of three and a group of five.}
}
\value{
\code{UnrootedTreesMatchingSplit()} returns an integer specifying the
number of unrooted bifurcating trees consistent with the specified split.
}
\description{
Calculates the number of unrooted bifurcating trees consistent with the
specified multi-partition split, using theorem two of
\insertCite{Carter1990;textual}{TreeTools}.
}
\examples{
UnrootedTreesMatchingSplit(c(3, 5))
UnrootedTreesMatchingSplit(3, 2, 1, 2)
}
\references{
\insertAllCited{}
}
\seealso{
Other split information functions: 
\code{\link{CharacterInformation}()},
\code{\link{SplitInformation}()},
\code{\link{SplitMatchProbability}()},
\code{\link{TreesMatchingSplit}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{split information functions}
