% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_files.R
\name{ExtractTaxa}
\alias{ExtractTaxa}
\alias{NexusTokens}
\title{Extract taxa from a matrix block}
\usage{
ExtractTaxa(matrixLines, character_num = NULL, session = NULL)

NexusTokens(tokens, character_num = NULL, session = NULL)
}
\arguments{
\item{matrixLines}{lines of a file containing a phylogenetic matrix
(see \code{\link{ReadCharacters}} for expected format).}

\item{character_num}{Index of character(s) to return.
\code{NULL}, the default, returns all characters.}

\item{session}{(optionally) a Shiny session with a numericInput named character_num
whose maximum should be updated.}

\item{tokens}{Vector of character strings corresponding to phylogenetic
tokens.}
}
\value{
\code{ExtractTaxa} returns a matrix with \emph{n} rows, each named for the
relevant taxon, and \emph{c} columns,
each corresponding to the respective character specified in \code{character_num}.

\code{NexusTokens} returns a character vector in which each entry
corresponds to the states of a phylogenetic character.
}
\description{
Reads the character information from a Nexus-formatted matrix into R.
}
\details{
Extracts the names of tips from the matrix block of a Nexus file.
}
\section{Functions}{
\itemize{
\item \code{NexusTokens}: Converts a Nexus string to a vector of character
states.
}}

\examples{
fileName <- paste0(system.file(package='TreeTools'),
                   '/extdata/input/dataset.nex')
matrixLines <- readLines(fileName)[6:11]
ExtractTaxa(matrixLines)

NexusTokens('01[01]-?')
}
\keyword{internal}
