% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdditionTree.R
\name{AdditionTree}
\alias{AdditionTree}
\title{Addition tree}
\usage{
AdditionTree(dataset, concavity = Inf, constraint, sequence)
}
\arguments{
\item{dataset}{A phylogenetic data matrix of class \code{\link[phangorn]{phyDat}},
whose names correspond to the labels of any accompanying tree.}

\item{concavity}{Numeric specifying concavity constant for implied step
weighting.
The most appropriate value will depend on the dataset, but values around
10--15 often perform well \insertCite{Goloboff2018,Smith2019}{TreeSearch}.
The character string "profile" employs an approximation of profile parsimony
\insertCite{Faith2001}{TreeSearch}.
Set as \code{Inf} for equal step weights, which underperforms step weighting
approaches
\insertCite{Goloboff2008,Goloboff2018,Goloboff2019,Smith2019}{TreeSearch}.}

\item{constraint}{An object of class \code{phyDat}; returned trees will be
perfectly compatible with each character in \code{constraint}.
See \code{\link[=ImposeConstraint]{ImposeConstraint()}} and
\href{https://ms609.github.io/TreeSearch/articles/inapplicable.html}{vignette}
for further examples.}

\item{sequence}{Character or numeric vector listing sequence in which to add
taxa. Randomized if not provided.}
}
\value{
\code{AdditionTree()} returns a tree of class \code{phylo}, rooted on
\code{sequence[1]}.
}
\description{
Generates a starting tree by adding each taxon in turn to the most
parsimonious location.
}
\examples{
data('Lobo', package = 'TreeTools')
AdditionTree(Lobo.phy, concavity = 10)
}
\seealso{
Impose a constraint: \href{https://ms609.github.io/TreeTools/reference/ImposeConstraint}{\code{TreeTools::ImposeConstraint()}}

Neighbour-joining trees: \href{https://ms609.github.io/TreeTools/reference/NJTree.html}{\code{TreeTools::NJTree()}};
\href{https://ms609.github.io/TreeTools/reference/ConstrainedNJ}{\code{TreeTools::ConstrainedNJ()}}

Other tree generation functions: 
\code{\link{RandomMorphyTree}()}
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree generation functions}
