% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_info_extra_step.r
\name{StepInformation}
\alias{StepInformation}
\title{Information content of a character known to contain \emph{e} steps}
\usage{
StepInformation(char, ambiguousTokens = c("-", "?"))
}
\arguments{
\item{char}{Vector of tokens listing states for the character in question.}

\item{ambiguousTokens}{Vector specifying which tokens, if any, correspond to
the ambiguous token (\verb{?}).}
}
\value{
\code{StepInformation()} returns a numeric vector detailing the amount
of phylogenetic information (in bits) associated with the character when
0, 1, 2… extra steps are present.  The vector is named with the
total number of steps associated with each entry in the vector: for example,
a character with three observed tokens must exhibit two steps, so the first
entry (zero extra steps) is named \code{2} (two steps observed).
}
\description{
\code{StepInformation()} calculates the phylogenetic information content of a
character \code{char} when \emph{e} extra steps are present, for all possible
values of \emph{e}.
}
\details{
Calculates the number of trees consistent with the character having
\emph{e} extra steps, where \emph{e} ranges from its minimum possible value
(i.e. number of different tokens minus one) to its maximum.
}
\examples{
character <- rep(c(0:3, '?', '-'), c(8, 5, 1, 1, 2, 2))
StepInformation(character)
}
\seealso{
Other profile parsimony functions: 
\code{\link{Carter1}()},
\code{\link{PrepareDataProfile}()},
\code{\link{profiles}}
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{profile parsimony functions}
