% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeSearch.R
\name{TreeSearch}
\alias{TreeSearch}
\title{Search for most parsimonious trees}
\usage{
TreeSearch(tree, dataset, InitializeData = function(tree, dataset)
  return(FALSE), CleanUpData = function(tree, dataset) return(NULL),
  TreeScorer = FitchScore, Rearrange = RootedTBR, maxIter = 100,
  maxHits = 20, forestSize = 1, verbosity = 1, ...)
}
\arguments{
\item{tree}{a fully-resolved starting tree in \code{\link{phylo}} format, with the desired outgroup; edge lengths are not supported and will be deleted;}

\item{dataset}{A phylogenetic data matrix of class \code{\link[phangorn]{phyDat}}, whose names 
correspond to the labels of any accompanying tree}

\item{InitializeData}{function to set up data object to prepare for tree search. Should return TRUE, unless a dataset needs to be sent to TreeScorer}

\item{CleanUpData}{function to destroy data object on function exit}

\item{TreeScorer}{function by which trees should be scored; default \code{\link{FitchScore}}}

\item{Rearrange}{rearrangement function to use; perhaps one of \kbd{RootedNNI}, \kbd{SPR}, or \kbd{TBR};}

\item{maxIter}{the maximum number of iterations to perform before abandoning the search;}

\item{maxHits}{the maximum times to hit the best pscore before abandoning the search;}

\item{forestSize}{the maximum number of trees to return - useful in concert with \code{\link{consensus}};}

\item{verbosity}{verbosity of output written to terminal; higher values print more messages}

\item{\dots}{further arguments to pass to \code{TreeScorer} function (e.g. \code{\link{TipsAreColumns}}, \code{dataset})}
}
\value{
{
This function returns a tree, with an attribute \code{pscore} conveying its parsimony score.
Note that the parsimony score will be inherited from the tree's attributes, which is only valid if it 
was generated using the same \code{data} that is passed here.
}
}
\description{
Run standard search algorithms (\acronym{NNI}, \acronym{SPR} or \acronym{TBR}) 
to search for a more parsimonious tree.
}
\examples{
data('Lobo')
njtree <- ape::root(ape::nj(phangorn::dist.hamming(Lobo.phy)), 'Cricocosmia', resolve.root=TRUE)
njtree$edge.length <- NULL

\dontrun{
TreeSearch(njtree, Lobo.phy, maxIter=20, Rearrange=NNI)
TreeSearch(njtree, Lobo.phy, maxIter=20, Rearrange=SPR)
TreeSearch(njtree, Lobo.phy, maxIter=20, Rearrange=TBR)}

}
\seealso{
\itemize{
\item \code{\link{Fitch}}, calculates parsimony score;
\item \code{\link{RootedNNI}}, conducts tree rearrangements;
\item \code{\link{Sectorial}}, alternative heuristic, useful for larger trees;
\item \code{\link{Ratchet}}, alternative heuristic, useful to escape local optima.
}
}
\author{
Martin R. Smith
}
\keyword{tree}
