% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Information.R
\encoding{UTF-8}
\name{AllSplitPairings}
\alias{AllSplitPairings}
\title{Variation of information for all split pairings}
\usage{
AllSplitPairings(n)
}
\arguments{
\item{n}{Integer specifying the number of leaves in a tree.}
}
\value{
\code{AllSplitPairings()} returns a named vector. The name of each
element corresponds to a certain variation of information, in bits; the
value of each element specifies the number of pairings of non-trivial
splits that give rise to that variation of information.
Split \code{AB|CD}  is treated as distinct from \code{CD|AB}.  If pairing
\code{AB|CD}=\code{CD|AB} is considered equivalent to \code{CD|AB}=\code{CD|AB} (etc), then
values should be divided by four.
}
\description{
Calculate the variation of clustering information
(Meil\ifelse{html}{\out{&#259;}}{a} 2007) for each possible pairing of
non-trivial splits on \emph{n} leaves, tabulating the number of pairings with
each similarity.
}
\examples{
AllSplitPairings(6)
# Treat equivalent splits as identical by dividing by four:
AllSplitPairings(6) / 4L
}
\references{
\insertRef{Meila2007}{TreeDist}

\insertRef{SmithDist}{TreeDist}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
