% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_distance_kendall-colijn.R
\name{KendallColijn}
\alias{KendallColijn}
\alias{KCVector}
\title{Kendall-Colijn distance}
\usage{
KendallColijn(tree1, tree2 = tree1)

KCVector(tree)
}
\arguments{
\item{tree1, tree2}{Trees of class \code{phylo}, with leaves labelled identically,
or lists of such trees to undergo pairwise comparison.  Where implemented,
\code{tree2 = NULL} will compute distances between each pair of trees in the list
\code{tree1} using a fast algorithm based on Day (1985).}

\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}
}
\value{
\code{KendallColijn()} returns an array of numerics providing the
distances between each  pair of trees in \code{tree1} and \code{tree2},
or \code{splits1} and \code{splits2}.
}
\description{
Calculate the Kendall-Colijn tree distance, a measure related to the
path difference.
}
\details{
The Kendall-Colijn distance works by measuring, for each pair of leaves,
the distance from the most recent
common ancestor of those leaves and the root node.  For a given tree, this
produces a vector of values recording the distance-from-the-root of each
most recent common ancestor of each pair of leaves.

Two trees are compared by taking the Euclidian distance between the
respective vectors.  This is calculated by taking the square root of the sum
of the squares of the differences between the vectors.

This metric emphasizes the position of the root; the path difference
instead measures the distance of the last common ancestor of each pair
of leaves from the leaves themselves, i.e. the length of the path from one
leaf to another.
}
\section{Functions}{
\itemize{
\item \code{KCVector}: Creates a vector that characterises a rooted tree,
as described in Kendall & Colijn (2016).
}}

\examples{
KendallColijn(TreeTools::BalancedTree(8), TreeTools::PectinateTree(8))

set.seed(0)
KendallColijn(TreeTools::BalancedTree(8), lapply(rep(8, 3), ape::rtree))
KendallColijn(lapply(rep(8, 4), ape::rtree))
}
\references{
\insertRef{Kendall2016}{TreeDist}
}
\seealso{
\href{https://CRAN.R-project.org/package=treespace/vignettes/introduction.html}{\code{treespace::treeDist}}
is a more sophisticated, if more cumbersome, implementation that supports
lambda > 0, i.e. use of edge lengths in tree comparison.

Other tree distances: 
\code{\link{JaccardRobinsonFoulds}()},
\code{\link{MASTSize}()},
\code{\link{MatchingSplitDistance}()},
\code{\link{NNIDist}()},
\code{\link{NyeSimilarity}()},
\code{\link{PathDist}()},
\code{\link{Robinson-Foulds}},
\code{\link{SPRDist}()},
\code{\link{TreeDistance}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree distances}
