context('lap.R')

test_that("LAPJV fails gracefully", {
  expect_equal(integer(0L), LAPJV(matrix(NA, 0, 0)))
  expect_error(LAPJV(1:10))
  expect_error(LAPJV(matrix(1, 3, 4)))
})

test_that("LAPJV doesn't crash", {
  matching <- LAPJV(matrix(c(2, 1, 1, 2), 2, 2))
  expect_equal(list(score = 2L, matching = 2:1), matching)
  
  prob1 <- matrix(c(0.961725,0.987491,0.998668,0.987491,0.961725,0.909537,0.94122,0.94122,0.995114,0.998918,0.983687,0.998918,0.995114,0.961725,0.961725,0.905982,0.894804,0.967235,0.927943,0.976313,0.998918,0.987491,0.987491,0.987491,0.950548,0.99657,0.992766,0.927943,0.983687,0.998668,0.998668,0.998668,0.983687,0.99657,0.992766,0.99657,0.950548,0.998668,0.998668,0.998668,0.781612,0.976313,0.99657,0.967235,0.894804,0.987491,0.987491,0.86522,0.848783,0.998918,0.983687,0.998918,0.995114,0.961725,0.961725,0.905982,0.905982,0.987491,0.998668,0.987491,0.961725,0.909537,0.94122,0.94122)
                 , 8, 8)

  lap1 <- LAPJV(t(prob1))
  prob2 <- matrix(c(4331226503423491,4447263344615913,4497602557256872,4447263344615913,4331226503423491,4096188537649521,4238877126856984,4238877126856984,4481594300586206,4498725985366606,4430131659835512,4498725985366607,4481594300586207,4331226503423489,4331226503423489,4080180280978857,4029841068337899,4356037396159145,4179085437390878,4396924131974953,4498725985366607,4447263344615912,4447263344615912,4447263344615912,4280887290782531,4488150080431723,4471018395651321,4179085437390879,4430131659835511,4497602557256871,4497602557256871,4497602557256871,4430131659835512,4488150080431723,4471018395651321,4488150080431722,4280887290782531,4497602557256870,4497602557256870,4497602557256870,3520069415493380,4396924131974953,4488150080431722,4356037396159145,4029841068337899,4447263344615912,4447263344615912,3896604955955584,3822578278688707,4498725985366607,4430131659835512,4498725985366607,4481594300586207,4331226503423491,4331226503423491,4080180280978857,4080180280978857,4447263344615912,4497602557256870,4447263344615912,4331226503423489,4096188537649521,4238877126856985,4238877126856985)
                 , 8, 8)
  expect_equal(LAPJV(prob2)$score / max(prob2) * max(prob1), lap1$score, 
               tolerance = 1e-06)
})

test_that("Avoid infinite loop in LAP", {
  library('TreeTools')
  tree1 <- PectinateTree(11L)
  tree2 <- as.phylo(18253832, 11L)
  owch <- 1927
  set.seed(0)
  randomTreeId <- unique(floor(runif(owch * 2) * NUnrooted(11)))[seq_len(owch)][owch]
  
  expect_equal(134.7911 / 11L, # What the function tells me is the right answer
               ClusteringInfoDistance(TreeTools::PectinateTree(11L),
                                      ape::as.phylo(18253832, 11L)),
               tolerance = 0.01) 
  expect_lt(0, ClusteringInfoDistance(TreeTools::PectinateTree(11L),
                                      ape::as.phylo(12848772, 11L)))
  
  expect_lt(0, ClusteringInfoDistance(TreeTools::PectinateTree(11L),
                                      Cladewise(Postorder(Preorder(ape::as.phylo(9850364, 11L))))
  ))
  
  expect_lt(0, ClusteringInfoDistance(TreeTools::PectinateTree(11L),
                                      ape::as.phylo(9850364, 11L)))
})
