% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatherGraphEdge.R
\name{gather_graph_edge}
\alias{gather_graph_edge}
\title{Gather graph edge from data frame
Please note that this function is from the 'ggraph' package and has not been altered in functionality,
but it has been optimized and iterated.
It is not original content of 'TransProR'.
However, since 'ggraph' caused frequent GitHub Action errors during the creation of 'TransProR',
the author directly referenced the involved functions in 'TransProR'.
This is not the author's original creation. All users please be aware!}
\usage{
gather_graph_edge(df, index = NULL, root = NULL)
}
\arguments{
\item{df}{A data frame}

\item{index}{A vector of column names to group by}

\item{root}{Root name for the root node connections, optional}
}
\value{
A tibble of graph edges
}
\description{
Gather graph edge from data frame
Please note that this function is from the 'ggraph' package and has not been altered in functionality,
but it has been optimized and iterated.
It is not original content of 'TransProR'.
However, since 'ggraph' caused frequent GitHub Action errors during the creation of 'TransProR',
the author directly referenced the involved functions in 'TransProR'.
This is not the author's original creation. All users please be aware!
}
\examples{
# Example taxonomic hierarchy data frame
OTU <- tibble::tibble(
  p = c("Firmicutes", "Firmicutes", "Bacteroidetes", "Bacteroidetes", "Proteobacteria"),
  c = c("Bacilli", "Clostridia", "Bacteroidia", "Bacteroidia", "Gammaproteobacteria"),
  o = c("Lactobacillales", "Clostridiales", "Bacteroidales", "Bacteroidales", "Enterobacterales"),
  abundance = c(100, 150, 200, 50, 300) # Abundance or some other metric
)

# Gathering graph edges by specifying hierarchical taxonomic levels
edges <- gather_graph_edge(OTU, index = c("p", "c", "o"))

# Adding a root node to the graph
edges_with_root <- gather_graph_edge(OTU, index = c("p", "c", "o"), root = "Root")

}
