% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_bindings.R
\name{set_denom_where}
\alias{set_denom_where}
\title{Set Logic for denominator subsetting}
\usage{
set_denom_where(e, denom_where)
}
\arguments{
\item{e}{A \code{count_layer/shift_layer} object}

\item{denom_where}{An expression (i.e. syntax) to be used to subset the
target dataset for calculating layer denominators. Supply as programming
logic (i.e. x < 5 & y == 10). To remove the layer where parameter
subsetting for the total row and thus the percentage denominators,
pass 'TRUE' to this function.}
}
\value{
The modified Tplyr layer object
}
\description{
By default, denominators in count layers are subset based on the layer level
where logic. In some cases this might not be correct. This functions allows
the user to override this behavior and pass custom logic that will be used to
subset the target dataset when calculating denominators for the layer.
}
\examples{
library(magrittr)
t10 <- tplyr_table(mtcars, gear) \%>\%
  add_layer(
    group_count(cyl, where = cyl != 6) \%>\%
    set_denom_where(TRUE)
    # The denominators will be based on all of the values, including 6
  ) \%>\%
 build()

}
